/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.mp3;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyGEOB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTALB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTBPM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCOM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCON;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCOP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDAT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTENC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTEXT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTFLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT3;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTKEY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTLAN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTLEN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMED;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOAL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOFN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOLY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOPE;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTORY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTOWN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE3;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE4;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPOS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPUB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRDA;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRSN;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRSO;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTSSE;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTYER;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUFID;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWCOM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWCOP;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAF;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWORS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWPAY;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWPUB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWXXX;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.extractor.mp3.Genre;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NID3;
import org.semanticdesktop.aperture.vocabulary.NIE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FrameIdentifier {
    AENC("Audio encryption", false),
    APIC("Attached picture", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            FrameBodyAPIC frameBodyAPIC = (FrameBodyAPIC)abstractTagFrameBody;
            Model model = rDFContainer.getModel();
            Resource resource = UriUtil.generateRandomResource(model);
            model.addStatement(resource, RDF.type, (Node)NFO.Attachment);
            model.addStatement(resource, RDF.type, (Node)NFO.Image);
            if (frameBodyAPIC.getMimeType() != null && frameBodyAPIC.getMimeType().length() > 0) {
                model.addStatement(resource, NIE.mimeType, frameBodyAPIC.getMimeType());
            }
            model.addStatement((Resource)rDFContainer.getDescribedUri(), NID3.attachedPicture, (Node)resource);
        }
    }
    ,
    COMM("Comments", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            String string = ((FrameBodyCOMM)abstractTagFrameBody).getDescription();
            boolean bl = string != null && string.length() > 0;
            String string2 = ((FrameBodyCOMM)abstractTagFrameBody).getText();
            boolean bl2 = string2 != null && string2.length() > 0;
            String string3 = (bl ? string : "") + (bl && bl2 ? "\n" : "") + (bl2 ? string2 : "");
            rDFContainer.add(NID3.comments, string3);
            hashMap.remove(NID3.comments);
        }
    }
    ,
    COMR("Commercial frame", false),
    ENCR("Encryption method registration", false),
    ETCO("Event timing codes", false),
    GEOB("General encapsulated object", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            FrameBodyGEOB frameBodyGEOB = (FrameBodyGEOB)abstractTagFrameBody;
            Model model = rDFContainer.getModel();
            Resource resource = UriUtil.generateRandomResource(model);
            model.addStatement(resource, RDF.type, (Node)NFO.Attachment);
            model.addStatement(resource, RDF.type, (Node)NIE.InformationElement);
            model.addStatement((Resource)rDFContainer.getDescribedUri(), NID3.generalEncapsulatedObject, (Node)resource);
        }
    }
    ,
    GRID("Group identification registration", false),
    LINK("Linked information", false),
    MCDI("Music CD identifier", false){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
        }
    }
    ,
    MLLT("MPEG location lookup table", false),
    OWNE("Ownership frame", false),
    PRIV("Private frame", false),
    PCNT("Play counter", false),
    POPM("Popularimeter", false),
    POSS("Position synchronisation frame", false),
    RBUF("Recommended buffer size", false),
    RVRB("Reverb", false),
    SYLT("Synchronised lyric/text", false),
    SYTC("Synchronised tempo codes", false),
    TALB("Album/Movie/Show title", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.albumTitle, ((FrameBodyTALB)abstractTagFrameBody).getFirstTextValue());
            hashMap.remove(NID3.albumTitle);
        }
    }
    ,
    TBPM("BPM (beats per minute)", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.beatsPerMinute, (Node)rDFContainer.getModel().createDatatypeLiteral(((FrameBodyTBPM)abstractTagFrameBody).getFirstTextValue(), XSD._integer));
        }
    }
    ,
    TCOM("Composer", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.composer, ((FrameBodyTCOM)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TCON("Content type", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            int n;
            String string = ((FrameBodyTCON)abstractTagFrameBody).getFirstTextValue();
            boolean bl = false;
            if (string.startsWith("(") && (n = string.indexOf(41)) != -1) {
                String string2 = string.substring(1, n);
                try {
                    int n2 = Integer.parseInt(string2);
                    Genre genre = Genre.getGenreByIntId(n2);
                    if (genre != null) {
                        rDFContainer.add(NID3.contentType, genre.getName());
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!bl) {
                rDFContainer.add(NID3.contentType, string);
            }
            hashMap.remove(NID3.contentType);
        }
    }
    ,
    TCOP("Copyright message", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.copyrightMessage, ((FrameBodyTCOP)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TDLY("Playlist delay", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.playlistDelay, (Node)rDFContainer.getModel().createDatatypeLiteral(((FrameBodyTBPM)abstractTagFrameBody).getFirstTextValue(), XSD._integer));
        }
    }
    ,
    TENC("Encoded by", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.encodedBy, ((FrameBodyTENC)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TEXT("Lyricist/Text writer", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.textWriter, ((FrameBodyTEXT)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TFLT("File type", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.fileType, ((FrameBodyTFLT)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TIT1("Content group description", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.contentGroupDescription, ((FrameBodyTIT1)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TIT2("Title/songname/content description", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.title, ((FrameBodyTIT2)abstractTagFrameBody).getFirstTextValue());
            hashMap.remove(NID3.title);
        }
    }
    ,
    TIT3("Subtitle/Description refinement", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.subtitle, ((FrameBodyTIT3)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TKEY("Initial key", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.initialKey, ((FrameBodyTKEY)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TLAN("Language(s)", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.language, ((FrameBodyTLAN)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TLEN("Length", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.length, ((FrameBodyTLEN)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TMED("Media type", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.mediaType, ((FrameBodyTMED)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TOAL("Original album/movie/show title", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.originalAlbumTitle, ((FrameBodyTOAL)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TOFN("Original filename", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.originalFilename, ((FrameBodyTOFN)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TOLY("Original lyricist(s)/text writer(s)", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.originalTextWriter, ((FrameBodyTOLY)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TOPE("Original artist(s)/performer(s)", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.originalArtist, ((FrameBodyTOPE)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TOWN("File owner/licensee", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.fileOwner, ((FrameBodyTOWN)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TPE1("Lead performer(s)/Soloist(s)", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.leadArtist, ((FrameBodyTPE1)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
            hashMap.remove(NID3.leadArtist);
        }
    }
    ,
    TPE2("Band/orchestra/accompaniment", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.backgroundArtist, ((FrameBodyTPE2)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TPE3("Conductor/performer refinement", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.conductor, ((FrameBodyTPE3)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TPE4("Interpreted, remixed, or otherwise modified by", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.interpretedBy, ((FrameBodyTPE4)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TPOS("Part of a set", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.partOfSet, ((FrameBodyTPOS)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TPUB("Publisher", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.publisher, ((FrameBodyTPUB)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TRCK("Track number/Position in set", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.trackNumber, ((FrameBodyTRCK)abstractTagFrameBody).getFirstTextValue());
            hashMap.remove(NID3.trackNumber);
        }
    }
    ,
    TRSN("Internet radio station name", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.internetRadioStationName, ((FrameBodyTRSN)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TRSO("Internet radio station owner", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            this.addSimpleContact(NID3.internetRadioStationOwner, ((FrameBodyTRSO)abstractTagFrameBody).getFirstTextValue(), rDFContainer);
        }
    }
    ,
    TSRC("ISRC (international standard recording code)", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.internationalStandardRecordingCode, ((FrameBodyTSRC)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TSSE("Software/Hardware and settings used for encoding", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.encodingSettings, ((FrameBodyTSSE)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TXXX("User defined text information frame", false){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            FrameBodyTXXX frameBodyTXXX = (FrameBodyTXXX)abstractTagFrameBody;
            String string = frameBodyTXXX.getDescription();
            String string2 = frameBodyTXXX.getText();
            Model model = rDFContainer.getModel();
            Resource resource = UriUtil.generateRandomResource(model);
            model.addStatement(resource, RDF.type, (Node)NID3.UserDefinedFrame);
            model.addStatement(resource, NID3.userDefinedFrameDescription, string);
            model.addStatement(resource, NID3.userDefinedFrameValue, string2);
            model.addStatement((Resource)rDFContainer.getDescribedUri(), NID3.userDefinedFrame, (Node)resource);
        }
    }
    ,
    UFID("Unique file identifier", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.uniqueFileIdentifier, ((FrameBodyUFID)abstractTagFrameBody).getOwner() + "/" + ((FrameBodyUFID)abstractTagFrameBody).getIdentifier());
        }
    }
    ,
    USER("Terms of use", false),
    USLT("Unsynchronised lyric/text transcription", false){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.unsynchronizedTextContent, ((FrameBodyUSLT)abstractTagFrameBody).getLyric());
        }
    }
    ,
    WCOM("Commercial information", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            URI uRI = rDFContainer.getModel().createURI(((FrameBodyWCOM)abstractTagFrameBody).getUrlLink());
            rDFContainer.add(NID3.commercialInformationURL, (Node)uRI);
            rDFContainer.getModel().addStatement((Resource)uRI, RDF.type, (Node)RDFS.Resource);
        }
    }
    ,
    WCOP("Copyright/Legal information", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            URI uRI = rDFContainer.getModel().createURI(((FrameBodyWCOP)abstractTagFrameBody).getUrlLink());
            rDFContainer.add(NID3.copyrightInformationURL, (Node)uRI);
            rDFContainer.getModel().addStatement((Resource)uRI, RDF.type, (Node)RDFS.Resource);
        }
    }
    ,
    WOAF("Official audio file webpage", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            URI uRI = rDFContainer.getModel().createURI(((FrameBodyWOAF)abstractTagFrameBody).getUrlLink());
            rDFContainer.add(NID3.officialFileWebpage, (Node)uRI);
            rDFContainer.getModel().addStatement((Resource)uRI, RDF.type, (Node)RDFS.Resource);
        }
    }
    ,
    WOAR("Official artist/performer webpage", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            URI uRI = rDFContainer.getModel().createURI(((FrameBodyWOAR)abstractTagFrameBody).getUrlLink());
            rDFContainer.add(NID3.officialArtistWebpage, (Node)uRI);
            rDFContainer.getModel().addStatement((Resource)uRI, RDF.type, (Node)RDFS.Resource);
        }
    }
    ,
    WOAS("Official audio source webpage", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            URI uRI = rDFContainer.getModel().createURI(((FrameBodyWOAS)abstractTagFrameBody).getUrlLink());
            rDFContainer.add(NID3.officialAudioSourceWebpage, (Node)uRI);
            rDFContainer.getModel().addStatement((Resource)uRI, RDF.type, (Node)RDFS.Resource);
        }
    }
    ,
    WORS("Official Internet radio station homepage", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            URI uRI = rDFContainer.getModel().createURI(((FrameBodyWORS)abstractTagFrameBody).getUrlLink());
            rDFContainer.add(NID3.officialInternetRadioStationHomepage, (Node)uRI);
            rDFContainer.getModel().addStatement((Resource)uRI, RDF.type, (Node)RDFS.Resource);
        }
    }
    ,
    WPAY("Payment", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            URI uRI = rDFContainer.getModel().createURI(((FrameBodyWPAY)abstractTagFrameBody).getUrlLink());
            rDFContainer.add(NID3.paymentURL, (Node)uRI);
            rDFContainer.getModel().addStatement((Resource)uRI, RDF.type, (Node)RDFS.Resource);
        }
    }
    ,
    WPUB("Publishers official webpage", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            URI uRI = rDFContainer.getModel().createURI(((FrameBodyWPUB)abstractTagFrameBody).getUrlLink());
            rDFContainer.add(NID3.publishersWebpage, (Node)uRI);
            rDFContainer.getModel().addStatement((Resource)uRI, RDF.type, (Node)RDFS.Resource);
        }
    }
    ,
    WXXX("User defined URL link frame", false){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            FrameBodyWXXX frameBodyWXXX = (FrameBodyWXXX)abstractTagFrameBody;
            String string = frameBodyWXXX.getDescription();
            String string2 = frameBodyWXXX.getUrlLink();
            Model model = rDFContainer.getModel();
            Resource resource = UriUtil.generateRandomResource(model);
            model.addStatement(resource, RDF.type, (Node)NID3.UserDefinedURLFrame);
            model.addStatement(resource, NID3.userDefinedFrameDescription, string);
            model.addStatement(resource, NID3.userDefinedFrameValue, string2);
            model.addStatement((Resource)rDFContainer.getDescribedUri(), NID3.userDefinedFrame, (Node)resource);
        }
    }
    ,
    ASPI("Audio seek point index", false),
    EQU2("Equalisation (2)", false),
    RVA2("Relative volume adjustment (2)", false),
    SEEK("Seek frame", false),
    SIGN("Signature frame", false),
    TDEN("Encoding time", false),
    TDOR("Original release time", false),
    TDRC("Recording time", false){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            FrameBodyTDRC frameBodyTDRC = (FrameBodyTDRC)abstractTagFrameBody;
            Date date = this.id3v24timestampToDate(frameBodyTDRC.getFirstTextValue());
            rDFContainer.add(NID3.date, date);
        }
    }
    ,
    TDRL("Release time", false),
    TDTG("Tagging time", false),
    TIPL("Involved people list", false),
    TMCL("Musician credits list", false),
    TMOO("Mood", false),
    TPRO("Produced notice", false),
    TSOA("Album sort order", false),
    TSOP("Performer sort order", false),
    TSOT("Title sort order", false),
    TSST("Set subtitle", false),
    EQUA("Equalization", false),
    IPLS("Involved people list", false),
    RVAD("Relative volume adjustment", false),
    TDAT("Date", false){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            FrameBodyTDAT frameBodyTDAT = (FrameBodyTDAT)abstractTagFrameBody;
            String string = frameBodyTDAT.getFirstTextValue();
            if (string.length() == 4) {
                try {
                    int n = Integer.parseInt(string.substring(0, 2));
                    int n2 = Integer.parseInt(string.substring(2, 4)) - 1;
                    String string2 = abstractID3v2Tag.getFirst(TYER.toString());
                    if (string2.length() > 0) {
                        int n3 = Integer.parseInt(string2);
                        String string3 = abstractID3v2Tag.getFirst(TIME.toString());
                        if (string3.length() > 0) {
                            int n4 = Integer.parseInt(string.substring(0, 2));
                            int n5 = Integer.parseInt(string.substring(2, 4));
                            GregorianCalendar gregorianCalendar = new GregorianCalendar(n3, n2, n, n4, n5);
                            rDFContainer.add(NID3.date, gregorianCalendar.getTime());
                        } else {
                            GregorianCalendar gregorianCalendar = new GregorianCalendar(n3, n2, n);
                            rDFContainer.add(NID3.date, gregorianCalendar.getTime());
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
    ,
    TIME("Time", false),
    TORY("Original release year", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.originalReleaseYear, (Node)rDFContainer.getModel().createDatatypeLiteral(((FrameBodyTORY)abstractTagFrameBody).getFirstTextValue(), XSD._integer));
        }
    }
    ,
    TRDA("Recording dates", false){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.recordingDate, ((FrameBodyTRDA)abstractTagFrameBody).getFirstTextValue());
        }
    }
    ,
    TSIZ("Size", false),
    TYER("Year", true){

        @Override
        public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
            rDFContainer.add(NID3.recordingYear, (Node)rDFContainer.getModel().createDatatypeLiteral(((FrameBodyTYER)abstractTagFrameBody).getFirstTextValue(), XSD._integer));
            hashMap.remove(NID3.recordingYear);
        }
    }
    ,
    BUF("Recommended buffer size", false),
    CNT("Play counter", false),
    COM("Comments", false),
    CRA("Audio encryption", false),
    CRM("Encrypted meta frame", false),
    ETC("Event timing codes", false),
    EQU("Equalization", false),
    GEO("General encapsulated object", false),
    IPL("Involved people list", false),
    LNK("Linked information", false),
    MCI("Music CD Identifier", false),
    MLL("MPEG location lookup table", false),
    PIC("Attached picture", false),
    POP("Popularimeter", false),
    REV("Reverb", false),
    RVA("Relative volume adjustment", false),
    SLT("Synchronized lyric/text", false),
    STC("Synced tempo codes", false),
    TAL("Album/Movie/Show title", false),
    TBP("BPM (Beats Per Minute)", false),
    TCM("Composer", false),
    TCO("Content type", false),
    TCR("Copyright message", false),
    TDA("Date", false),
    TDY("Playlist delay", false),
    TEN("Encoded by", false),
    TFT("File type", false),
    TIM("Time", false),
    TKE("Initial key", false),
    TLA("Language(s)", false),
    TLE("Length", false),
    TMT("Media type", false),
    TOA("Original artist(s)/performer(s)", false),
    TOF("Original filename", false),
    TOL("Original Lyricist(s)/text writer(s)", false),
    TOR("Original release year", false),
    TOT("Original album/Movie/Show title", false),
    TP1("Lead artist(s)/Lead performer(s)/Soloist(s)/Performing group", false),
    TP2("Band/Orchestra/Accompaniment", false),
    TP3("Conductor/Performer refinement", false),
    TP4("Interpreted, remixed, or otherwise modified by", false),
    TPA("Part of a set", false),
    TPB("Publisher", false),
    TRC("ISRC (International Standard Recording Code)", false),
    TRD("Recording dates", false),
    TRK("Track number/Position in set", false),
    TSI("Size", false),
    TSS("Software/hardware and settings used for encoding", false),
    TT1("Content group description", false),
    TT2("Title/Songname/Content description", false),
    TT3("Subtitle/Description refinement", false),
    TXT("Lyricist/text writer", false),
    TXX("User defined text information frame", false),
    TYE("Year", false),
    UFI("Unique file identifier", false),
    ULT("Unsychronized lyric/text transcription", false),
    WAF("Official audio file webpage", false),
    WAR("Official artist/performer webpage", false),
    WAS("Official audio source webpage", false),
    WCM("Commercial information", false),
    WCP("Copyright/Legal information", false),
    WPB("Publishers official webpage", false),
    WXX("User defined URL link frame", false);

    private String name;
    private boolean isSupported;

    private FrameIdentifier(String string2, boolean bl) {
        this.name = string2;
        this.isSupported = bl;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public void process(AbstractTagFrameBody abstractTagFrameBody, AbstractID3v2Tag abstractID3v2Tag, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
    }

    protected void addSimpleContact(URI uRI, String string, RDFContainer rDFContainer) {
        Model model = rDFContainer.getModel();
        Resource resource = UriUtil.generateRandomResource(model);
        model.addStatement(resource, RDF.type, (Node)NCO.Contact);
        model.addStatement(resource, NCO.fullname, string);
        model.addStatement((Resource)rDFContainer.getDescribedUri(), uRI, (Node)resource);
    }

    protected Date id3v24timestampToDate(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("asdfasdfasd"));
        gregorianCalendar.set(0, 0, 1, 0, 0, 0);
        gregorianCalendar.set(1, Integer.parseInt(string.substring(0, 4)));
        if (string.length() == 4) {
            return gregorianCalendar.getTime();
        }
        gregorianCalendar.set(2, Integer.parseInt(string.substring(5, 2)) - 1);
        if (string.length() == 7) {
            return gregorianCalendar.getTime();
        }
        gregorianCalendar.set(5, Integer.parseInt(string.substring(8, 2)));
        if (string.length() == 10) {
            return gregorianCalendar.getTime();
        }
        gregorianCalendar.set(10, Integer.parseInt(string.substring(11, 2)));
        if (string.length() == 13) {
            return gregorianCalendar.getTime();
        }
        gregorianCalendar.set(12, Integer.parseInt(string.substring(14, 2)));
        if (string.length() == 16) {
            return gregorianCalendar.getTime();
        }
        gregorianCalendar.set(13, Integer.parseInt(string.substring(17, 2)));
        return gregorianCalendar.getTime();
    }
}

