/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.LockException;
import org.ontoware.rdf2go.exception.MalformedQueryException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.exception.SyntaxNotSupportedException;
import org.ontoware.rdf2go.model.DiffReader;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.QuadPattern;
import org.ontoware.rdf2go.model.QueryResultTable;
import org.ontoware.rdf2go.model.QueryRow;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.TriplePattern;
import org.ontoware.rdf2go.model.impl.DiffImpl;
import org.ontoware.rdf2go.model.impl.LazyUnionModelIterator;
import org.ontoware.rdf2go.model.impl.QuadPatternImpl;
import org.ontoware.rdf2go.model.impl.StatementImpl;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.RDF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelSetImpl
implements ModelSet {
    private boolean locked = false;

    public void dump() {
        ClosableIterator it = this.getModels();
        while (it.hasNext()) {
            Model m = (Model)it.next();
            System.out.println("Dumping model with context: " + m.getContextURI() + " ----------");
            m.dump();
            m.close();
        }
    }

    public void removeAll() throws ModelRuntimeException {
        LinkedList models = new LinkedList();
        ClosableIterator it = this.getModels();
        while (it.hasNext()) {
            models.add(it.next());
        }
        for (Model m : models) {
            assert (m.isOpen());
            m.removeAll();
        }
    }

    public Statement createStatement(URI context, Resource subject, URI predicate, Node object) {
        return new StatementImpl(context, subject, predicate, object);
    }

    public void readFrom(Reader in, Syntax syntax) throws IOException, ModelRuntimeException, SyntaxNotSupportedException {
        if (syntax != Syntax.Trix) {
            throw new SyntaxNotSupportedException("Syntax '" + syntax + "' not supported. Or the adapter implementor was too lazy to override thid method");
        }
        this.readFrom(in);
    }

    public void readFrom(InputStream in, Syntax syntax) throws IOException, ModelRuntimeException, SyntaxNotSupportedException {
        if (syntax != Syntax.Trix) {
            throw new SyntaxNotSupportedException("Syntax '" + syntax + "' not supported. Or the adapter implementor was too lazy to override thid method");
        }
        this.readFrom(in);
    }

    public void writeTo(Writer writer, Syntax syntax) throws IOException, ModelRuntimeException, SyntaxNotSupportedException {
        if (syntax != Syntax.Trix) {
            throw new SyntaxNotSupportedException("Syntax '" + syntax + "' not supported. Or the adapter implementor was too lazy to override thid method");
        }
        this.writeTo(writer);
    }

    public void writeTo(OutputStream out, Syntax syntax) throws IOException, ModelRuntimeException, SyntaxNotSupportedException {
        if (syntax != Syntax.Trix) {
            throw new SyntaxNotSupportedException("Syntax '" + syntax + "' not supported. Or the adapter implementor was too lazy to override thid method");
        }
        this.writeTo(out);
    }

    public String serialize(Syntax syntax) throws SyntaxNotSupportedException {
        StringWriter sw = new StringWriter();
        try {
            this.writeTo(sw, syntax);
        }
        catch (IOException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        return sw.getBuffer().toString();
    }

    public boolean containsStatements(UriOrVariable contextURI, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        ClosableIterator<Statement> it = this.findStatements(contextURI, subject, predicate, object);
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    public void addStatement(URI context, Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.addStatement(this.createStatement(context, subject, predicate, object));
    }

    public void addAll(Iterator<? extends Statement> statement) throws ModelRuntimeException {
        while (statement.hasNext()) {
            this.addStatement(statement.next());
        }
    }

    public void removeStatement(URI context, Resource subject, URI predicate, Node object) throws ModelRuntimeException {
        this.removeStatement(this.createStatement(context, subject, predicate, object));
    }

    public void removeAll(Iterator<? extends Statement> statement) throws ModelRuntimeException {
        while (statement.hasNext()) {
            this.removeStatement(statement.next());
        }
    }

    public void removeStatements(QuadPattern quadPattern) throws ModelRuntimeException {
        this.removeStatements(quadPattern.getContext(), quadPattern.getSubject(), quadPattern.getPredicate(), quadPattern.getObject());
    }

    public void removeStatements(UriOrVariable context, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        ClosableIterator<Statement> it = this.findStatements(context, subject, predicate, object);
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            stmts.add(stmt);
        }
        it.close();
        for (Statement stmt : stmts) {
            this.removeStatement(stmt);
        }
    }

    public BlankNode createBlankNode() {
        return this.getDefaultModel().createBlankNode();
    }

    public BlankNode createBlankNode(String internalID) {
        return this.getDefaultModel().createBlankNode(internalID);
    }

    public URI createURI(String uriString) throws ModelRuntimeException {
        return this.getDefaultModel().createURI(uriString);
    }

    public boolean isValidURI(String uriString) {
        return this.getDefaultModel().isValidURI(uriString);
    }

    public PlainLiteral createPlainLiteral(String literal) {
        return this.getDefaultModel().createPlainLiteral(literal);
    }

    public LanguageTagLiteral createLanguageTagLiteral(String literal, String langugeTag) throws ModelRuntimeException {
        return this.getDefaultModel().createLanguageTagLiteral(literal, langugeTag);
    }

    public DatatypeLiteral createDatatypeLiteral(String literal, URI datatypeURI) throws ModelRuntimeException {
        return this.getDefaultModel().createDatatypeLiteral(literal, datatypeURI);
    }

    public Statement createStatement(Resource subject, URI predicate, Node object) {
        Model defaultModel = this.getDefaultModel();
        Statement statement = defaultModel.createStatement(subject, predicate, object);
        defaultModel.close();
        return statement;
    }

    public URI newRandomUniqueURI() {
        return this.getDefaultModel().newRandomUniqueURI();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() throws LockException {
        if (this.isLocked()) {
            throw new LockException("Already locked");
        }
        this.locked = true;
    }

    public void unlock() {
        this.locked = false;
    }

    public boolean contains(Statement s) throws ModelRuntimeException {
        QuadPatternImpl quadPattern = new QuadPatternImpl((UriOrVariable)s.getContext(), (ResourceOrVariable)s.getSubject(), (UriOrVariable)s.getPredicate(), (NodeOrVariable)s.getObject());
        ClosableIterator<Statement> x = this.findStatements(quadPattern);
        boolean result = x.hasNext();
        x.close();
        return result;
    }

    public long countStatements(QuadPattern pattern) throws ModelRuntimeException {
        ClosableIterator<Statement> it = this.findStatements(pattern);
        long count = 0L;
        while (it.hasNext()) {
            while (it.hasNext()) {
                ++count;
                it.next();
            }
        }
        return count;
    }

    public ClosableIterator<Statement> findStatements(QuadPattern pattern) throws ModelRuntimeException {
        if (pattern.getContext() == Variable.ANY) {
            return new LazyUnionModelIterator(this, (TriplePattern)pattern);
        }
        assert (pattern.getContext() instanceof URI);
        Model m = this.getModel((URI)pattern.getContext());
        return m.findStatements((TriplePattern)pattern);
    }

    public ClosableIterator<Statement> findStatements(UriOrVariable contextURI, ResourceOrVariable subject, UriOrVariable predicate, NodeOrVariable object) throws ModelRuntimeException {
        QuadPattern quadPattern = this.createQuadPattern(contextURI, subject, predicate, object);
        return this.findStatements(quadPattern);
    }

    public ClosableIterator<Statement> iterator() {
        return new LazyUnionModelIterator(this, new QuadPatternImpl((UriOrVariable)Variable.ANY, (ResourceOrVariable)Variable.ANY, (UriOrVariable)Variable.ANY, (NodeOrVariable)Variable.ANY));
    }

    public boolean addModel(Model model) {
        for (Statement s : model) {
            this.addStatement(model.getContextURI(), s.getSubject(), s.getPredicate(), s.getObject());
        }
        return true;
    }

    public void addModelSet(ModelSet modelSet) {
        for (Statement s : modelSet) {
            this.addStatement(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DiffReader diff) throws ModelRuntimeException {
        AbstractModelSetImpl abstractModelSetImpl = this;
        synchronized (abstractModelSetImpl) {
            if (this.isLocked()) {
                throw new ModelRuntimeException("ModelSet is locked, cannot perform an update.");
            }
            for (Statement stmt : diff.getRemoved()) {
                this.removeStatement(stmt);
            }
            for (Statement stmt : diff.getAdded()) {
                this.addStatement(stmt);
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public boolean sparqlAsk(String query) throws ModelRuntimeException, MalformedQueryException {
        QueryResultTable table = this.sparqlSelect(query);
        ClosableIterator it = table.iterator();
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    public BlankNode addReificationOf(Statement statement) {
        BlankNode bnode = this.createBlankNode();
        return (BlankNode)this.addReificationOf(statement, (Resource)bnode);
    }

    public Resource addReificationOf(Statement statement, Resource resource) {
        DiffImpl diff = new DiffImpl();
        diff.addStatement(this.createStatement(statement.getContext(), resource, RDF.type, (Node)RDF.Statement));
        diff.addStatement(this.createStatement(statement.getContext(), resource, RDF.subject, (Node)statement.getSubject()));
        diff.addStatement(this.createStatement(statement.getContext(), resource, RDF.predicate, (Node)statement.getPredicate()));
        diff.addStatement(this.createStatement(statement.getContext(), resource, RDF.object, statement.getObject()));
        this.update((DiffReader)diff);
        return resource;
    }

    public boolean hasReifications(Statement statement) {
        return this.sparqlAsk("ASK WHERE {  ?res " + RDF.type.toSPARQL() + " " + RDF.Statement + " ." + " ?res " + RDF.subject.toSPARQL() + " " + statement.getSubject().toSPARQL() + " ." + " ?res " + RDF.predicate.toSPARQL() + " " + statement.getPredicate().toSPARQL() + " ." + " ?res " + RDF.object.toSPARQL() + " " + statement.getObject().toSPARQL() + " ." + " }");
    }

    public Collection<Resource> getAllReificationsOf(Statement statement) {
        QueryResultTable table = this.sparqlSelect("SELECT ?res WHERE {  ?res " + RDF.type.toSPARQL() + " " + RDF.Statement + " ." + " ?res " + RDF.subject.toSPARQL() + " " + statement.getSubject().toSPARQL() + " ." + " ?res " + RDF.predicate.toSPARQL() + " " + statement.getPredicate().toSPARQL() + " ." + " ?res " + RDF.object.toSPARQL() + " " + statement.getObject().toSPARQL() + " ." + " }");
        LinkedList<Resource> result = new LinkedList<Resource>();
        ClosableIterator it = table.iterator();
        while (it.hasNext()) {
            Resource res = ((QueryRow)it.next()).getValue("res").asResource();
            result.add(res);
        }
        it.close();
        return result;
    }

    public void deleteReification(Resource reificationResource) {
        DiffImpl diff = new DiffImpl();
        diff.removeStatement(reificationResource, RDF.type, (Node)RDF.Statement);
        ClosableIterator<Statement> it = this.findStatements((UriOrVariable)Variable.ANY, (ResourceOrVariable)reificationResource, (UriOrVariable)RDF.subject, (NodeOrVariable)Variable.ANY);
        while (it.hasNext()) {
            diff.removeStatement((Statement)it.next());
        }
        it.close();
        it = this.findStatements((UriOrVariable)Variable.ANY, (ResourceOrVariable)reificationResource, (UriOrVariable)RDF.predicate, (NodeOrVariable)Variable.ANY);
        while (it.hasNext()) {
            diff.removeStatement((Statement)it.next());
        }
        it.close();
        it = this.findStatements((UriOrVariable)Variable.ANY, (ResourceOrVariable)reificationResource, (UriOrVariable)RDF.object, (NodeOrVariable)Variable.ANY);
        while (it.hasNext()) {
            diff.removeStatement((Statement)it.next());
        }
        it.close();
        this.update((DiffReader)diff);
    }

    public void addModel(Model model, URI contextURI) {
        ClosableIterator it = model.iterator();
        HashSet<Statement> statements = new HashSet<Statement>();
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            statements.add(stmt);
        }
        it.close();
        for (Statement stmt : statements) {
            this.addStatement(contextURI, stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModelIterator
    implements Iterator<Model> {
        private Iterator<URI> iterator;

        public ModelIterator(Iterator<URI> modelURIs) {
            this.iterator = modelURIs;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Model next() {
            return AbstractModelSetImpl.this.getModel(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.next();
        }
    }
}

