/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rdf2go;

import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.QueryRow;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.rdf2go.QueryRowWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRowIterator
implements ClosableIterator<QueryRow> {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TupleQueryResult queryResult;
    private boolean closed = false;

    public QueryRowIterator(TupleQueryResult queryResult) {
        this.queryResult = queryResult;
    }

    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean hasNext = false;
        try {
            hasNext = this.queryResult.hasNext();
        }
        catch (QueryEvaluationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public QueryRow next() {
        BindingSet nextBindingSet = null;
        try {
            nextBindingSet = (BindingSet)this.queryResult.next();
            if (!this.queryResult.hasNext()) {
                this.close();
            }
        }
        catch (QueryEvaluationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        return new QueryRowWrapper(nextBindingSet);
    }

    public void remove() {
        try {
            this.queryResult.remove();
        }
        catch (QueryEvaluationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public void close() {
        try {
            this.queryResult.close();
        }
        catch (QueryEvaluationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.logger.warn(this.getClass().getName() + " not closed, closing now");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

