/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.common.buffer.FileAllocator;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerTransportProcessor;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.TransportProcessor;
import org.simpleframework.transport.TransportSocketProcessor;

public class ContainerSocketProcessor
implements SocketProcessor {
    private final TransportProcessor processor;
    private final SocketProcessor adapter;

    public ContainerSocketProcessor(Container container) throws IOException {
        this(container, 8);
    }

    public ContainerSocketProcessor(Container container, int count) throws IOException {
        this(container, count, 1);
    }

    public ContainerSocketProcessor(Container container, int count, int select) throws IOException {
        this(container, (Allocator)new FileAllocator(), count, select);
    }

    public ContainerSocketProcessor(Container container, Allocator allocator) throws IOException {
        this(container, allocator, 8);
    }

    public ContainerSocketProcessor(Container container, Allocator allocator, int count) throws IOException {
        this(container, allocator, count, 1);
    }

    public ContainerSocketProcessor(Container container, Allocator allocator, int count, int select) throws IOException {
        this.processor = new ContainerTransportProcessor(container, allocator, count, select);
        this.adapter = new TransportSocketProcessor(this.processor, count);
    }

    public void process(Socket socket) throws IOException {
        this.adapter.process(socket);
    }

    public void stop() throws IOException {
        this.adapter.stop();
    }
}

