/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.http.message.BoundaryConsumer;
import org.simpleframework.http.message.ByteConsumer;
import org.simpleframework.http.message.PartConsumer;
import org.simpleframework.http.message.PartSeries;
import org.simpleframework.transport.ByteCursor;

class PartEntryConsumer
implements ByteConsumer {
    private final BoundaryConsumer boundary;
    private final ByteConsumer consumer;

    public PartEntryConsumer(Allocator allocator, PartSeries series, byte[] terminal, long length) {
        this.consumer = new PartConsumer(allocator, series, terminal, length);
        this.boundary = new BoundaryConsumer(allocator, terminal);
    }

    public void consume(ByteCursor cursor) throws IOException {
        while (cursor.isReady()) {
            if (!this.boundary.isFinished()) {
                this.boundary.consume(cursor);
                continue;
            }
            if (this.consumer.isFinished() || this.boundary.isEnd()) break;
            this.consumer.consume(cursor);
        }
    }

    public boolean isFinished() {
        if (this.boundary.isEnd()) {
            return true;
        }
        return this.consumer.isFinished();
    }

    public boolean isEnd() {
        return this.boundary.isEnd();
    }
}

