/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.parse;

import org.simpleframework.common.parse.Parser;
import org.simpleframework.http.Path;

public class PathParser
extends Parser
implements Path {
    private TokenList list = new TokenList();
    private Token name;
    private Token ext = new Token();
    private Token dir = new Token();
    private Token path = new Token();

    public PathParser() {
        this.name = new Token();
    }

    public PathParser(String path) {
        this();
        this.parse(path);
    }

    protected void parse() {
        this.normalize();
        this.path();
        this.segments();
        this.name();
        this.extension();
    }

    protected void init() {
        this.list.clear();
        this.ext.clear();
        this.dir.clear();
        this.name.clear();
        this.path.clear();
        this.off = 0;
    }

    public String getExtension() {
        return this.ext.toString();
    }

    public String getName() {
        return this.name.toString();
    }

    public String getPath() {
        return this.path.toString();
    }

    public String getPath(int from) {
        return this.list.segment(from);
    }

    public String getPath(int from, int count) {
        return this.list.segment(from, count);
    }

    public String getDirectory() {
        return this.dir.toString();
    }

    public String[] getSegments() {
        return this.list.list();
    }

    public String getRelative(String path) {
        return this.getRelative(new PathParser(path));
    }

    private String getRelative(PathParser path) {
        char[] text = path.buf;
        int off = path.dir.off;
        int len = path.dir.len;
        return this.getRelative(text, off, len);
    }

    private String getRelative(char[] text, int off, int len) {
        if (len > this.path.len) {
            return null;
        }
        int size = this.path.len - len + 1;
        int pos = this.path.off + len - 1;
        for (int i = 0; i < len; ++i) {
            if (text[off++] == this.buf[this.path.off + i]) continue;
            return null;
        }
        if (pos < 0) {
            return null;
        }
        return new String(this.buf, pos, size);
    }

    private void path() {
        if (this.count > 0) {
            this.path.len = this.count;
            this.path.off = 0;
        }
    }

    private void extension() {
        int pos = this.off + this.count;
        int len = 0;
        while (pos - 1 >= this.off) {
            if (this.buf[--pos] == '.') {
                this.ext.off = pos + 1;
                this.ext.len = len;
                this.count = pos;
                break;
            }
            ++len;
        }
    }

    private void segments() {
        int pos = this.count - 1;
        int len = 1;
        if (this.count > 0) {
            if (this.buf[pos] == '/') {
                this.dir.len = pos + 1;
                this.dir.off = 0;
                --pos;
            }
            while (pos >= this.off) {
                if (this.buf[pos] == '/') {
                    if (this.dir.len == 0) {
                        this.dir.len = pos + 1;
                        this.dir.off = 0;
                    }
                    this.list.add(pos + 1, len - 1);
                    len = 0;
                }
                ++len;
                --pos;
            }
        }
    }

    private void normalize() {
        int size = this.count + this.off;
        this.count = 0;
        this.off = 0;
        for (int pos = this.off; pos < size; ++pos) {
            this.buf[this.count++] = this.buf[pos];
            if (this.buf[pos] != '.' || this.count - 1 > 0 && this.buf[this.count - 2] != '/') continue;
            if (pos + 2 > size) {
                --this.count;
                continue;
            }
            if (this.buf[pos + 1] == '/') {
                ++pos;
                --this.count;
            }
            if (this.buf[pos] != '.' || pos + 2 < size && this.buf[pos + 2] != '/') continue;
            if (this.count - 2 > 0) {
                this.count -= 2;
                while (this.count - 1 > 0 && this.buf[this.count - 1] != '/') {
                    --this.count;
                }
            } else {
                this.count = 0;
                this.off = 0;
                break;
            }
            pos += 2;
        }
    }

    private void name() {
        int pos = this.count;
        int len = 0;
        while (pos-- > this.off) {
            if (this.buf[pos] == ';') {
                if (this.buf[pos - 1] == '/') {
                    --pos;
                }
                len = 0;
                continue;
            }
            if (this.buf[pos] == '/') {
                this.off = pos + 1;
                this.count = len;
                break;
            }
            ++len;
        }
        this.name.len = this.count;
        this.name.off = this.off;
    }

    public String toString() {
        return this.getPath();
    }

    private class TokenList {
        private String[] cache;
        private int[] list = new int[16];
        private int count;

        private TokenList() {
        }

        public String segment(int from) {
            int total = this.count / 2;
            int left = total - from;
            return this.segment(from, left);
        }

        public String segment(int from, int total) {
            int last = this.list[0] + this.list[1] + 1;
            if (from + total < this.count / 2) {
                last = this.offset(from + total);
            }
            int start = this.offset(from);
            int length = last - start;
            return new String(PathParser.this.buf, start - 1, length);
        }

        private int offset(int segment) {
            int last = this.count - 2;
            int shift = segment * 2;
            int index = last - shift;
            return this.list[index];
        }

        public void add(int off, int len) {
            if (this.count + 1 > this.list.length) {
                this.resize(this.count * 2);
            }
            this.list[this.count++] = off;
            this.list[this.count++] = len;
        }

        public String[] list() {
            if (this.cache == null) {
                this.cache = this.build();
            }
            return this.cache;
        }

        private String[] build() {
            String[] value = new String[this.count / 2];
            int j = this.count / 2;
            for (int i = 0; i < this.count; i += 2) {
                int index = j - i / 2 - 1;
                int off = this.list[i];
                int size = this.list[i + 1];
                value[index] = new String(PathParser.this.buf, off, size);
            }
            return value;
        }

        public void clear() {
            this.cache = null;
            this.count = 0;
        }

        private void resize(int size) {
            int[] copy = new int[size];
            System.arraycopy(this.list, 0, copy, 0, this.count);
            this.list = copy;
        }
    }

    private class Token {
        public String value;
        public int off;
        public int len;

        private Token() {
        }

        public void clear() {
            this.value = null;
            this.len = 0;
        }

        public String toString() {
            if (this.value != null) {
                return this.value;
            }
            if (this.len > 0) {
                this.value = new String(PathParser.this.buf, this.off, this.len);
            }
            return this.value;
        }
    }
}

