/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket;

public class DataConverter {
    private final String charset;

    public DataConverter() {
        this("UTF-8");
    }

    public DataConverter(String charset) {
        this.charset = charset;
    }

    public byte[] convert(String text) {
        try {
            return text.getBytes(this.charset);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not encode text as " + this.charset, e);
        }
    }

    public String convert(byte[] binary) {
        try {
            return new String(binary, this.charset);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not decode data as " + this.charset, e);
        }
    }

    public String convert(byte[] binary, int offset, int size) {
        try {
            return new String(binary, offset, size, this.charset);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not decode data as " + this.charset, e);
        }
    }
}

