/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform.lang;

import org.simpleframework.xml.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterArrayTransform
implements Transform<Character[]> {
    @Override
    public Character[] read(String value) throws Exception {
        int length = value.length();
        if (length > 0) {
            return this.read(value, length);
        }
        return new Character[0];
    }

    private Character[] read(String value, int length) throws Exception {
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Character.valueOf(value.charAt(i));
        }
        return array;
    }

    @Override
    public String write(Character[] value) throws Exception {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) continue;
            text.append(value[i]);
        }
        return text.toString();
    }
}

