/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.DeferredType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.LeastUpperBound;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeSubstitutionSolver;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Type;

public class TypeInferenceSolver {
    private final Symbols symbols;
    private final LeastUpperBound leastUpperBound;
    private final TypeSubstitutionSolver typeSubstitutionSolver;

    public TypeInferenceSolver(LeastUpperBound leastUpperBound, Symbols symbols, TypeSubstitutionSolver typeSubstitutionSolver) {
        this.symbols = symbols;
        this.leastUpperBound = leastUpperBound;
        this.typeSubstitutionSolver = typeSubstitutionSolver;
    }

    TypeSubstitution inferTypeSubstitution(JavaSymbol.MethodJavaSymbol method, List<JavaType> formals, List<JavaType> argTypes) {
        boolean isVarArgs = method.isVarArgs();
        int numberFormals = formals.size();
        int numberArgs = argTypes.size();
        int numberParamToCheck = Math.min(numberFormals, numberArgs);
        ArrayList<JavaType> newArgTypes = new ArrayList<JavaType>(argTypes);
        TypeSubstitution substitution = new TypeSubstitution();
        if (isVarArgs && numberFormals == numberArgs + 1) {
            ++numberParamToCheck;
            newArgTypes.add(this.symbols.objectType);
        }
        for (int i = 0; i < numberParamToCheck; ++i) {
            JavaType formalType = formals.get(i);
            JavaType argType = (JavaType)newArgTypes.get(i);
            boolean variableArity = isVarArgs && i == numberFormals - 1;
            ArrayList<JavaType> remainingArgTypes = new ArrayList<JavaType>(newArgTypes.subList(i, newArgTypes.size()));
            substitution = this.inferTypeSubstitution(method, substitution, formalType, argType, variableArity, remainingArgTypes);
            if (!method.isConstructor() && substitution.typeVariables().containsAll(method.typeVariableTypes)) break;
        }
        return substitution;
    }

    private TypeSubstitution inferTypeSubstitution(JavaSymbol.MethodJavaSymbol method, TypeSubstitution substitution, JavaType formalType, JavaType argumentType, boolean variableArity, List<JavaType> remainingArgTypes) {
        JavaType argType = argumentType;
        if (argType.isTagged(17) && ((DeferredType)argType).getUninferedType() != null) {
            argType = ((DeferredType)argType).getUninferedType();
        }
        TypeSubstitution result = substitution;
        if (formalType.isTagged(15)) {
            result = this.completeSubstitution(substitution, formalType, argType);
        } else if (formalType.isArray()) {
            result = this.inferTypeSubstitutionInArrayType(method, substitution, (ArrayJavaType)formalType, argType, variableArity, remainingArgTypes);
        } else if (formalType.isParameterized()) {
            result = this.inferTypeSubstitutionInParameterizedType(method, substitution, (ParametrizedTypeJavaType)formalType, argType, variableArity, remainingArgTypes);
        } else if (formalType.isTagged(16)) {
            result = this.inferTypeSubstitutionInWildcardType(method, substitution, (WildCardType)formalType, argType, variableArity, remainingArgTypes);
        }
        return result;
    }

    private TypeSubstitution inferTypeSubstitutionInArrayType(JavaSymbol.MethodJavaSymbol method, TypeSubstitution substitution, ArrayJavaType formalType, JavaType argType, boolean variableArity, List<JavaType> remainingArgTypes) {
        JavaType newArgType = null;
        if (argType.isArray()) {
            newArgType = ((ArrayJavaType)argType).elementType;
        } else if (variableArity) {
            newArgType = (JavaType)this.leastUpperBound.leastUpperBound(TypeInferenceSolver.mapToBoxedSet(remainingArgTypes));
        }
        if (newArgType != null) {
            TypeSubstitution newSubstitution = this.inferTypeSubstitution(method, substitution, formalType.elementType, newArgType, variableArity, remainingArgTypes);
            return TypeInferenceSolver.mergeTypeSubstitutions(substitution, newSubstitution);
        }
        return substitution;
    }

    private static Set<Type> mapToBoxedSet(List<JavaType> types) {
        return types.stream().map(type -> type.isPrimitive() ? type.primitiveWrapperType : type).collect(Collectors.toSet());
    }

    private TypeSubstitution inferTypeSubstitutionInParameterizedType(JavaSymbol.MethodJavaSymbol method, TypeSubstitution substitution, ParametrizedTypeJavaType formalType, JavaType argType, boolean variableArity, List<JavaType> remainingArgTypes) {
        TypeSubstitution result;
        block4: {
            block6: {
                List<JavaType> formalTypeSubstitutedTypes;
                block5: {
                    JavaType javaType;
                    Object newSubstitution;
                    formalTypeSubstitutedTypes = formalType.typeSubstitution.substitutedTypes();
                    result = substitution;
                    if (!argType.isParameterized()) break block5;
                    ParametrizedTypeJavaType parametrizedArgType = (ParametrizedTypeJavaType)argType;
                    if (parametrizedArgType.rawType == formalType.rawType) {
                        List<JavaType> list = parametrizedArgType.typeSubstitution.substitutedTypes();
                        TypeSubstitution newSubstitution2 = this.inferTypeSubstitution(method, formalTypeSubstitutedTypes, list);
                        return TypeInferenceSolver.mergeTypeSubstitutions(substitution, newSubstitution2);
                    }
                    JavaType javaType2 = argType.symbol.getSuperclass();
                    if (javaType2 != null && !((TypeSubstitution)(newSubstitution = this.inferTypeSubstitutionInParameterizedType(method, substitution, formalType, javaType = this.typeSubstitutionSolver.applySubstitution(javaType2, parametrizedArgType.typeSubstitution), variableArity, remainingArgTypes))).substitutedTypes().isEmpty()) {
                        result = TypeInferenceSolver.mergeTypeSubstitutions(substitution, (TypeSubstitution)newSubstitution);
                    }
                    for (JavaType superInterface : argType.symbol.getInterfaces()) {
                        JavaType javaType3 = this.typeSubstitutionSolver.applySubstitution(superInterface, parametrizedArgType.typeSubstitution);
                        TypeSubstitution newSubstitution3 = this.inferTypeSubstitutionInParameterizedType(method, substitution, formalType, javaType3, variableArity, remainingArgTypes);
                        if (newSubstitution3.substitutedTypes().isEmpty()) continue;
                        result = TypeInferenceSolver.mergeTypeSubstitutions(substitution, newSubstitution3);
                    }
                    break block4;
                }
                if (!TypeInferenceSolver.isRawTypeOfType(argType, formalType) && !this.isNullType(argType)) break block6;
                List<JavaType> objectTypes = TypeInferenceSolver.listOfTypes(this.symbols.objectType, formalTypeSubstitutedTypes.size());
                TypeSubstitution typeSubstitution = this.inferTypeSubstitution(method, formalTypeSubstitutedTypes, objectTypes);
                result = TypeInferenceSolver.mergeTypeSubstitutions(substitution, typeSubstitution);
                break block4;
            }
            if (!argType.isSubtypeOf(formalType.erasure()) || !argType.isClass()) break block4;
            for (JavaType javaType : ((ClassJavaType)argType).symbol.superTypes()) {
                if (!TypeInferenceSolver.sameErasure(formalType, javaType)) continue;
                TypeSubstitution newSubstitution = this.inferTypeSubstitution(method, substitution, formalType, javaType, variableArity, remainingArgTypes);
                result = TypeInferenceSolver.mergeTypeSubstitutions(substitution, newSubstitution);
                break;
            }
        }
        return result;
    }

    private static boolean isRawTypeOfType(JavaType rawType, JavaType type) {
        return rawType == type.erasure();
    }

    private static List<JavaType> listOfTypes(JavaType type, int size) {
        ArrayList<JavaType> result = new ArrayList<JavaType>(size);
        for (int j = 0; j < size; ++j) {
            result.add(type);
        }
        return result;
    }

    private static boolean sameErasure(JavaType type1, JavaType type2) {
        return type1.erasure() == type2.erasure();
    }

    private boolean isNullType(JavaType type) {
        return type == this.symbols.nullType;
    }

    private TypeSubstitution inferTypeSubstitutionInWildcardType(JavaSymbol.MethodJavaSymbol method, TypeSubstitution substitution, WildCardType formalType, JavaType argType, boolean variableArity, List<JavaType> remainingArgTypes) {
        JavaType newArgType = argType;
        if (argType.isTagged(16)) {
            newArgType = ((WildCardType)argType).bound;
        }
        TypeSubstitution newSubstitution = this.inferTypeSubstitution(method, substitution, formalType.bound, newArgType, variableArity, remainingArgTypes);
        return TypeInferenceSolver.mergeTypeSubstitutions(substitution, newSubstitution);
    }

    private static TypeSubstitution mergeTypeSubstitutions(TypeSubstitution currentSubstitution, TypeSubstitution newSubstitution) {
        TypeSubstitution result = new TypeSubstitution();
        for (Map.Entry<TypeVariableJavaType, JavaType> substitution : currentSubstitution.substitutionEntries()) {
            result.add(substitution.getKey(), substitution.getValue());
        }
        for (Map.Entry<TypeVariableJavaType, JavaType> substitution : newSubstitution.substitutionEntries()) {
            if (result.typeVariables().contains(substitution.getKey())) continue;
            result.add(substitution.getKey(), substitution.getValue());
        }
        return result;
    }

    private TypeSubstitution completeSubstitution(TypeSubstitution substitution, JavaType formalType, JavaType argType) {
        TypeSubstitution result = new TypeSubstitution(substitution);
        if (formalType.isTagged(15) && substitution.substitutedType(formalType) == null) {
            JavaType expectedType = argType;
            if (expectedType.isPrimitive()) {
                expectedType = expectedType.primitiveWrapperType;
            } else if (this.isNullType(expectedType)) {
                expectedType = this.symbols.objectType;
            }
            TypeVariableJavaType typeVar = (TypeVariableJavaType)formalType;
            result.add(typeVar, expectedType);
        }
        return result;
    }
}

