/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.profiles.ProfileDefinition;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.checks.CheckList;
import org.sonar.plugins.java.JavaRulesDefinition;

public class JavaSonarWayProfile
extends ProfileDefinition {
    private final Gson gson = new Gson();
    private final RuleFinder ruleFinder;

    public JavaSonarWayProfile(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    public RulesProfile createProfile(ValidationMessages messages) {
        RulesProfile profile = RulesProfile.create((String)"Sonar way", (String)"java");
        URL resource = JavaRulesDefinition.class.getResource("/org/sonar/l10n/java/rules/squid/Sonar_way_profile.json");
        Profile jsonProfile = (Profile)this.gson.fromJson(JavaSonarWayProfile.readResource(resource), Profile.class);
        Map<String, String> keys = JavaSonarWayProfile.legacyKeys();
        for (String key : jsonProfile.ruleKeys) {
            profile.activateRule(this.ruleFinder.findByKey("squid", keys.get(key)), null);
        }
        return profile;
    }

    private static String readResource(URL resource) {
        try {
            return Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read: " + resource, e);
        }
    }

    private static Map<String, String> legacyKeys() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Class checkClass : CheckList.getChecks()) {
            Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation((Object)checkClass, Rule.class);
            String key = ruleAnnotation.key();
            RspecKey rspecKeyAnnotation = (RspecKey)AnnotationUtils.getAnnotation((Object)checkClass, RspecKey.class);
            String rspecKey = key;
            if (rspecKeyAnnotation != null) {
                rspecKey = rspecKeyAnnotation.value();
            }
            result.put(rspecKey, key);
        }
        return result;
    }

    private static class Profile {
        String name;
        List<String> ruleKeys;

        private Profile() {
        }
    }
}

