/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import javax.annotation.Nullable;

class Utils {
    private Utils() {
    }

    static String join(String[] array, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = Arrays.asList(array).iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) break;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    static boolean taskRequiresProject(Properties props) {
        Object task = props.get("sonar.task");
        return task == null || "scan".equals(task);
    }

    static void writeProperties(File outputFile, Properties p) {
        try (FileOutputStream output = new FileOutputStream(outputFile);){
            p.store(output, "Generated by sonar-runner");
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to export sonar-runner properties", e);
        }
    }

    static void deleteQuietly(File f) {
        try {
            Files.walkFileTree(f.toPath(), new DeleteQuietlyFileVisitor());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void closeQuietly(@Nullable Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class DeleteQuietlyFileVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteQuietlyFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            try {
                Files.delete(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            try {
                Files.delete(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            try {
                Files.delete(dir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

