/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.sonar.api.internal.google.common.collect.Iterators;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class LocalizedMessages
extends ResourceBundle {
    private static final Logger LOG = Loggers.get(LocalizedMessages.class);
    private Locale locale;
    private List<ResourceBundle> bundles;

    public LocalizedMessages(Locale locale, String ... basenames) {
        this.locale = locale;
        this.bundles = new ArrayList<ResourceBundle>(basenames.length);
        for (String basename : basenames) {
            this.bundles.add(LocalizedMessages.getBundle("sonar.bundles." + basename, locale));
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public String format(String key, Object ... args) {
        return this.format(true, key, args);
    }

    public String formatQuietly(String key, Object ... args) {
        return this.format(false, key, args);
    }

    private String format(boolean logIfMissing, String key, Object ... args) {
        try {
            String message = this.getString(key);
            return String.format(this.locale, message, args);
        }
        catch (MissingResourceException e) {
            if (logIfMissing) {
                LOG.warn("Missing translation: key==" + key + ",locale=" + this.locale);
            }
            return key;
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        return new KeyEnumeration();
    }

    @Override
    protected Object handleGetObject(String key) {
        for (ResourceBundle b : this.bundles) {
            try {
                return b.getObject(key);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        throw new MissingResourceException(null, null, key);
    }

    private class KeyEnumeration
    implements Enumeration<String> {
        private Set<String> keys = new HashSet<String>();
        private Iterator<String> i;

        private KeyEnumeration() {
            for (ResourceBundle b : LocalizedMessages.this.bundles) {
                this.keys.addAll(Lists.newArrayList(Iterators.forEnumeration(b.getKeys())));
            }
            this.i = this.keys.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        @Override
        public String nextElement() {
            return this.i.next();
        }
    }
}

