/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.post;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sourcelab.kafka.connect.apiclient.request.post.PostRequest;
import org.sourcelab.kafka.connect.apiclient.util.UrlEscapingUtil;

public final class PostConnectorRestart
implements PostRequest<Boolean> {
    private final String connectorName;
    private Map<String, Boolean> options = new HashMap<String, Boolean>();

    public PostConnectorRestart(String connectorName) {
        Objects.requireNonNull(connectorName);
        this.connectorName = connectorName;
    }

    public PostConnectorRestart withIncludeTasks(boolean includeTasks) {
        this.options.put("includeTasks", includeTasks);
        return this;
    }

    public PostConnectorRestart withOnlyFailed(boolean onlyFailed) {
        this.options.put("onlyFailed", onlyFailed);
        return this;
    }

    @Override
    public String getApiEndpoint() {
        String url = "/connectors/" + UrlEscapingUtil.escapePath(this.connectorName) + "/restart";
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, Boolean> option : this.options.entrySet()) {
            if (option.getValue() == null) continue;
            params.add(option.getKey() + "=" + (option.getValue() != false ? "true" : "false"));
        }
        if (params.size() > 0) {
            url = url + "?" + String.join((CharSequence)"&", params);
        }
        return url;
    }

    @Override
    public Object getRequestBody() {
        return "";
    }

    @Override
    public Boolean parseResponse(String responseStr) throws IOException {
        return true;
    }
}

