/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.CharacterCodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFTimestampFieldString;
import org.apache.hadoop.io.Text;

public final class VectorUDFWeekOfYearString
extends VectorUDFTimestampFieldString {
    private static final long serialVersionUID = 1L;
    private final transient SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private final transient Calendar calendar = Calendar.getInstance();

    public VectorUDFWeekOfYearString(int colNum, int outputColumn) {
        super(colNum, outputColumn, -1, -1);
        this.initCalendar();
    }

    public VectorUDFWeekOfYearString() {
        this.initCalendar();
    }

    @Override
    protected long doGetField(byte[] bytes, int start, int length) throws ParseException {
        Date date = null;
        try {
            String decoded = Text.decode((byte[])bytes, (int)start, (int)length);
            date = this.format.parse(decoded);
        }
        catch (CharacterCodingException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        this.calendar.setTime(date);
        return this.calendar.get(3);
    }

    private void initCalendar() {
        this.calendar.setFirstDayOfWeek(2);
        this.calendar.setMinimalDaysInFirstWeek(4);
    }
}

