/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.SystemVariables;
import org.apache.hadoop.hive.ql.session.SessionState;

public class VariableSubstitution
extends SystemVariables {
    private static final Log l4j = LogFactory.getLog(VariableSubstitution.class);

    @Override
    protected String getSubstitute(Configuration conf, String var) {
        String val = super.getSubstitute(conf, var);
        if (val == null && SessionState.get() != null) {
            Map<String, String> vars = SessionState.get().getHiveVariables();
            val = var.startsWith("hivevar:") ? vars.get(var.substring("hivevar:".length())) : vars.get(var);
        }
        return val;
    }

    public String substitute(HiveConf conf, String expr) {
        if (expr == null) {
            return expr;
        }
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEVARIABLESUBSTITUTE)) {
            return expr;
        }
        l4j.debug((Object)("Substitution is on: " + expr));
        int depth = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVEVARIABLESUBSTITUTEDEPTH);
        return this.substitute(conf, expr, depth);
    }
}

