/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseParserException;
import org.spdx.licenseTemplate.LicenseTemplateRule;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.utility.compare.LicenseCompareHelper;
import org.spdx.utility.compare.LineColumn;
import org.spdx.utility.compare.SpdxCompareException;

public class TemplateRegexMatcher
implements ILicenseTemplateOutputHandler {
    static final Logger logger = LoggerFactory.getLogger(TemplateRegexMatcher.class);
    static final int WORD_LIMIT = 25;
    static final String REGEX_GLOBAL_MODIFIERS = "(?im)";
    private String template;
    private RegexList regexPatternList = new RegexList();
    private int optionalNestLevel = 0;
    private List<OptionalRegexGroup> optionalGroups = new ArrayList<OptionalRegexGroup>();

    public TemplateRegexMatcher(String template) throws SpdxCompareException {
        this.template = template;
        this.parseTemplate();
    }

    private void parseTemplate() throws SpdxCompareException {
        try {
            SpdxLicenseTemplateHelper.parseTemplate(LicenseCompareHelper.removeCommentChars(this.template), this);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during filter: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during filter: " + e.getMessage(), e);
        }
    }

    public String getCompleteRegex() {
        return REGEX_GLOBAL_MODIFIERS + this.regexPatternList.toString();
    }

    public String getQuickMatchRegex(int wordLimit) {
        RegexElement element;
        RegexList result = new RegexList();
        int index = 0;
        int numWords = 0;
        List<RegexElement> elementList = this.regexPatternList.getElements();
        int largestContiguousText = 0;
        while (index < elementList.size() && numWords <= wordLimit) {
            element = elementList.get(index++);
            result.addElement(element);
            if (element instanceof RegexToken) {
                ++numWords;
                continue;
            }
            if (numWords > largestContiguousText) {
                largestContiguousText = numWords;
            }
            result.getElements().clear();
            numWords = 0;
        }
        if (numWords < largestContiguousText) {
            while (index < elementList.size() && numWords <= largestContiguousText) {
                element = elementList.get(index++);
                result.addElement(element);
                if (element instanceof RegexToken) {
                    ++numWords;
                    continue;
                }
                result.getElements().clear();
                numWords = 0;
            }
        }
        return REGEX_GLOBAL_MODIFIERS + result.toString();
    }

    public String getStartRegex(int wordLimit) {
        String pattern;
        RegexElement firstElement;
        RegexList result = new RegexList();
        int index = 0;
        int numWords = 0;
        List<RegexElement> elementList = this.regexPatternList.getElements();
        while (index < elementList.size() && numWords <= wordLimit) {
            RegexElement element = elementList.get(index++);
            result.addElement(element);
            if (!(element instanceof RegexToken)) continue;
            ++numWords;
        }
        if (!result.getElements().isEmpty() && (firstElement = result.getElements().get(0)) instanceof RegexPattern && !(pattern = ((RegexPattern)firstElement).pattern).startsWith(".?") && pattern.startsWith(".")) {
            ((RegexPattern)firstElement).setPattern(".?" + pattern.substring(1));
        }
        return REGEX_GLOBAL_MODIFIERS + result.toString();
    }

    public String getEndRegex(int wordLimit) {
        RegexList result = new RegexList();
        int numWords = 0;
        List<RegexElement> elementList = this.regexPatternList.getElements();
        int index = elementList.size() - 1;
        while (index > 0 && numWords <= wordLimit) {
            if (!(elementList.get(index--) instanceof RegexToken)) continue;
            ++numWords;
        }
        while (index < elementList.size()) {
            result.addElement(elementList.get(index++));
        }
        return REGEX_GLOBAL_MODIFIERS + result.toString();
    }

    public boolean isTemplateMatchWithinText(String text) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (text == null || text.isEmpty()) {
            return false;
        }
        String completeText = this.findTemplateWithinText(text);
        if (completeText != null) {
            return !LicenseCompareHelper.isTextMatchingTemplate(this.template, completeText).isDifferenceFound();
        }
        return false;
    }

    @Nullable
    private String findTemplateWithinText(String text) {
        Pattern startPattern;
        Matcher startMatcher;
        String result = null;
        int startIndex = -1;
        int endIndex = -1;
        if (text == null || text.isEmpty() || this.template == null) {
            return null;
        }
        StringBuilder normalizedText = new StringBuilder();
        for (String token : LicenseCompareHelper.tokenizeLicenseText(LicenseCompareHelper.removeLineSeparators(LicenseCompareHelper.removeCommentChars(text)), new HashMap<Integer, LineColumn>())) {
            normalizedText.append(LicenseCompareHelper.NORMALIZE_TOKENS.getOrDefault(token.toLowerCase(), token.toLowerCase()));
            normalizedText.append(' ');
        }
        String compareText = normalizedText.toString();
        Pattern quickPattern = Pattern.compile(this.getQuickMatchRegex(25));
        if (quickPattern.matcher(compareText).find() && (startMatcher = (startPattern = Pattern.compile(this.getStartRegex(25))).matcher(compareText)).find()) {
            startIndex = startMatcher.start();
            Pattern endPattern = Pattern.compile(this.getEndRegex(25));
            Matcher endMatcher = endPattern.matcher(compareText);
            if (endMatcher.find()) {
                endIndex = endMatcher.end();
                result = compareText.substring(startIndex, endIndex);
            }
        }
        return result;
    }

    private RegexList getCurrentList() {
        return this.optionalNestLevel == 0 ? this.regexPatternList : (RegexList)this.optionalGroups.get(this.optionalNestLevel - 1);
    }

    @Override
    public void text(String text) {
        RegexList currentList = this.getCurrentList();
        for (String token : LicenseCompareHelper.tokenizeLicenseText(text, new HashMap<Integer, LineColumn>())) {
            currentList.addElement(new RegexToken(LicenseCompareHelper.NORMALIZE_TOKENS.getOrDefault(token.toLowerCase(), token.toLowerCase())));
        }
    }

    @Override
    public void variableRule(LicenseTemplateRule rule) {
        this.getCurrentList().addElement(new RegexPattern(rule.getMatch()));
    }

    @Override
    public void beginOptional(LicenseTemplateRule rule) {
        ++this.optionalNestLevel;
        if (this.optionalGroups.size() == this.optionalNestLevel) {
            logger.warn("Optional groups size does not match the nest level");
            this.optionalGroups.set(this.optionalNestLevel - 1, new OptionalRegexGroup());
        } else {
            this.optionalGroups.add(new OptionalRegexGroup());
        }
    }

    @Override
    public void endOptional(LicenseTemplateRule rule) {
        OptionalRegexGroup optionalGroup = this.optionalGroups.get(this.optionalNestLevel - 1);
        this.optionalGroups.remove(this.optionalNestLevel - 1);
        --this.optionalNestLevel;
        this.getCurrentList().addElement(optionalGroup);
    }

    @Override
    public void completeParsing() throws LicenseParserException {
    }

    static class RegexList
    implements RegexElement {
        private List<RegexElement> elements = new ArrayList<RegexElement>();

        RegexList() {
        }

        public void addElement(RegexElement element) {
            this.elements.add(element);
        }

        public List<RegexElement> getElements() {
            return this.elements;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (RegexElement element : this.elements) {
                sb.append(element.toString());
            }
            return sb.toString();
        }
    }

    static interface RegexElement {
    }

    static class RegexToken
    implements RegexElement {
        private String token;

        public RegexToken(String token) {
            this.token = token.trim();
        }

        public String getToken() {
            return this.token;
        }

        public String toString() {
            return Pattern.quote(LicenseCompareHelper.NORMALIZE_TOKENS.getOrDefault(this.token.toLowerCase(), this.token)) + "\\s*";
        }
    }

    static class RegexPattern
    implements RegexElement {
        private String pattern;

        public RegexPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String toString() {
            return "(" + this.pattern + ")";
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }

    static class OptionalRegexGroup
    extends RegexList {
        OptionalRegexGroup() {
        }

        @Override
        public String toString() {
            return "(" + super.toString() + ")?";
        }
    }
}

