/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SpringDocPropertiesUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConfigurationProperties(prefix="springdoc.swagger-ui")
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerUiConfigProperties {
    public static final String CONFIG_URL_PROPERTY = "configUrl";
    public static final String LAYOUT_PROPERTY = "layout";
    public static final String FILTER_PROPERTY = "filter";
    public static final String URLS_PROPERTY = "urls";
    public static final String OAUTH2_REDIRECT_URL_PROPERTY = "oauth2RedirectUrl";
    private String path = "/swagger-ui.html";
    private String layout;
    private String configUrl;
    private String validatorUrl;
    private String filter;
    private String operationsSorter;
    private String tagsSorter;
    private Boolean deepLinking;
    private Boolean displayOperationId;
    private Integer defaultModelsExpandDepth;
    private Integer defaultModelExpandDepth;
    private String defaultModelRendering;
    private Boolean displayRequestDuration;
    private String docExpansion;
    private Integer maxDisplayedTags;
    private Boolean showExtensions;
    private Boolean showCommonExtensions;
    private List<String> supportedSubmitMethods;
    private String oauth2RedirectUrl = "/swagger-ui/oauth2-redirect.html";
    private String url;
    private Set<SwaggerUrl> urls = new HashSet<SwaggerUrl>();
    private Direction groupsOrder = Direction.ASC;
    private String urlsPrimaryName;
    private boolean disableSwaggerDefaultUrl;
    private boolean displayQueryParams;
    private boolean displayQueryParamsWithoutOauth2;

    public void addGroup(String group) {
        SwaggerUrl swaggerUrl = new SwaggerUrl(group);
        this.urls.add(swaggerUrl);
    }

    public Set<SwaggerUrl> getUrls() {
        return this.urls;
    }

    public void setUrls(Set<SwaggerUrl> urls) {
        this.urls = urls;
    }

    public void addUrl(String url) {
        this.urls.forEach(elt -> {
            if (StringUtils.isBlank((CharSequence)((SwaggerUrl)elt).url)) {
                elt.setUrl(url + "/" + elt.getName());
            }
        });
    }

    public Map<String, Object> getConfigParameters() {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("validatorUrl", this.validatorUrl != null ? this.validatorUrl : "");
        SpringDocPropertiesUtils.put(CONFIG_URL_PROPERTY, this.configUrl, params);
        SpringDocPropertiesUtils.put("deepLinking", this.deepLinking, params);
        SpringDocPropertiesUtils.put("displayOperationId", this.displayOperationId, params);
        SpringDocPropertiesUtils.put("defaultModelsExpandDepth", this.defaultModelsExpandDepth, params);
        SpringDocPropertiesUtils.put("defaultModelExpandDepth", this.defaultModelExpandDepth, params);
        SpringDocPropertiesUtils.put("defaultModelRendering", this.defaultModelRendering, params);
        SpringDocPropertiesUtils.put("displayRequestDuration", this.displayRequestDuration, params);
        SpringDocPropertiesUtils.put("docExpansion", this.docExpansion, params);
        SpringDocPropertiesUtils.put("maxDisplayedTags", this.maxDisplayedTags, params);
        SpringDocPropertiesUtils.put("showExtensions", this.showExtensions, params);
        SpringDocPropertiesUtils.put("showCommonExtensions", this.showCommonExtensions, params);
        SpringDocPropertiesUtils.put("operationsSorter", this.operationsSorter, params);
        SpringDocPropertiesUtils.put("tagsSorter", this.tagsSorter, params);
        if (!CollectionUtils.isEmpty(this.supportedSubmitMethods)) {
            SpringDocPropertiesUtils.put("supportedSubmitMethods", this.supportedSubmitMethods.toString(), params);
        }
        SpringDocPropertiesUtils.put(OAUTH2_REDIRECT_URL_PROPERTY, this.oauth2RedirectUrl, params);
        SpringDocPropertiesUtils.put("url", this.url, params);
        this.put(URLS_PROPERTY, this.urls, params);
        SpringDocPropertiesUtils.put("urls.primaryName", this.urlsPrimaryName, params);
        return params;
    }

    public String getValidatorUrl() {
        return this.validatorUrl;
    }

    public void setValidatorUrl(String validatorUrl) {
        this.validatorUrl = validatorUrl;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getConfigUrl() {
        return this.configUrl;
    }

    public void setConfigUrl(String configUrl) {
        this.configUrl = configUrl;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getOperationsSorter() {
        return this.operationsSorter;
    }

    public void setOperationsSorter(String operationsSorter) {
        this.operationsSorter = operationsSorter;
    }

    public String getTagsSorter() {
        return this.tagsSorter;
    }

    public void setTagsSorter(String tagsSorter) {
        this.tagsSorter = tagsSorter;
    }

    public Boolean getDeepLinking() {
        return this.deepLinking;
    }

    public void setDeepLinking(Boolean deepLinking) {
        this.deepLinking = deepLinking;
    }

    public Boolean getDisplayOperationId() {
        return this.displayOperationId;
    }

    public void setDisplayOperationId(Boolean displayOperationId) {
        this.displayOperationId = displayOperationId;
    }

    public Integer getDefaultModelsExpandDepth() {
        return this.defaultModelsExpandDepth;
    }

    public void setDefaultModelsExpandDepth(Integer defaultModelsExpandDepth) {
        this.defaultModelsExpandDepth = defaultModelsExpandDepth;
    }

    public Integer getDefaultModelExpandDepth() {
        return this.defaultModelExpandDepth;
    }

    public void setDefaultModelExpandDepth(Integer defaultModelExpandDepth) {
        this.defaultModelExpandDepth = defaultModelExpandDepth;
    }

    public String getDefaultModelRendering() {
        return this.defaultModelRendering;
    }

    public void setDefaultModelRendering(String defaultModelRendering) {
        this.defaultModelRendering = defaultModelRendering;
    }

    public Boolean getDisplayRequestDuration() {
        return this.displayRequestDuration;
    }

    public void setDisplayRequestDuration(Boolean displayRequestDuration) {
        this.displayRequestDuration = displayRequestDuration;
    }

    public String getDocExpansion() {
        return this.docExpansion;
    }

    public void setDocExpansion(String docExpansion) {
        this.docExpansion = docExpansion;
    }

    public Integer getMaxDisplayedTags() {
        return this.maxDisplayedTags;
    }

    public void setMaxDisplayedTags(Integer maxDisplayedTags) {
        this.maxDisplayedTags = maxDisplayedTags;
    }

    public Boolean getShowExtensions() {
        return this.showExtensions;
    }

    public void setShowExtensions(Boolean showExtensions) {
        this.showExtensions = showExtensions;
    }

    public Boolean getShowCommonExtensions() {
        return this.showCommonExtensions;
    }

    public void setShowCommonExtensions(Boolean showCommonExtensions) {
        this.showCommonExtensions = showCommonExtensions;
    }

    public List<String> getSupportedSubmitMethods() {
        return this.supportedSubmitMethods;
    }

    public void setSupportedSubmitMethods(List<String> supportedSubmitMethods) {
        this.supportedSubmitMethods = supportedSubmitMethods;
    }

    public String getOauth2RedirectUrl() {
        return this.oauth2RedirectUrl;
    }

    public void setOauth2RedirectUrl(String oauth2RedirectUrl) {
        this.oauth2RedirectUrl = oauth2RedirectUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isDisableSwaggerDefaultUrl() {
        return this.disableSwaggerDefaultUrl;
    }

    public void setDisableSwaggerDefaultUrl(boolean disableSwaggerDefaultUrl) {
        this.disableSwaggerDefaultUrl = disableSwaggerDefaultUrl;
    }

    public boolean isDisplayQueryParams() {
        return this.displayQueryParams;
    }

    public void setDisplayQueryParams(boolean displayQueryParams) {
        this.displayQueryParams = displayQueryParams;
    }

    public boolean isDisplayQueryParamsWithoutOauth2() {
        return this.displayQueryParamsWithoutOauth2;
    }

    public void setDisplayQueryParamsWithoutOauth2(boolean displayQueryParamsWithoutOauth2) {
        this.displayQueryParamsWithoutOauth2 = displayQueryParamsWithoutOauth2;
    }

    public boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void put(String urls, Set<SwaggerUrl> swaggerUrls, Map<String, Object> params) {
        Comparator<SwaggerUrl> swaggerUrlComparator = this.groupsOrder.isAscending() ? Comparator.comparing(SwaggerUrl::getName) : (h1, h2) -> h2.getName().compareTo(h1.getName());
        if (!CollectionUtils.isEmpty((Collection)(swaggerUrls = (Set)swaggerUrls.stream().sorted(swaggerUrlComparator).filter(elt -> StringUtils.isNotEmpty((CharSequence)elt.getUrl())).collect(Collectors.toCollection(LinkedHashSet::new))))) {
            params.put(urls, swaggerUrls);
        }
    }

    public Direction getGroupsOrder() {
        return this.groupsOrder;
    }

    public void setGroupsOrder(Direction groupsOrder) {
        this.groupsOrder = groupsOrder;
    }

    public String getUrlsPrimaryName() {
        return this.urlsPrimaryName;
    }

    public void setUrlsPrimaryName(String urlsPrimaryName) {
        this.urlsPrimaryName = urlsPrimaryName;
    }

    static class SwaggerUrl {
        private String url;
        private String name;

        public SwaggerUrl() {
        }

        public SwaggerUrl(String group, String url) {
            Objects.requireNonNull(group, "Group name can not be null");
            this.url = url;
            this.name = group;
        }

        public SwaggerUrl(String group) {
            Objects.requireNonNull(group, "Group name can not be null");
            this.name = group;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SwaggerUrl that = (SwaggerUrl)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SwaggerUrl{");
            sb.append("url='").append(this.url).append('\'');
            sb.append(", name='").append(this.name).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    static enum Direction {
        ASC,
        DESC;


        public boolean isAscending() {
            return this.equals((Object)ASC);
        }
    }
}

