/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springdoc.core.CacheOrGroupedOpenApiCondition;
import org.springdoc.core.GenericParameterBuilder;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.RequestBodyBuilder;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SecurityParser;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.SpringdocBeanFactoryConfigurer;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springdoc.core.converters.FileSupportConverter;
import org.springdoc.core.converters.ModelConverterRegistrar;
import org.springdoc.core.converters.PolymorphicModelConverter;
import org.springdoc.core.converters.PropertyCustomizingConverter;
import org.springdoc.core.converters.ResponseSupportConverter;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.customizers.OpenApiBuilderCustomiser;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.PropertyCustomizer;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;

@Configuration
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class SpringDocConfiguration {
    private static final String BINDRESULT_CLASS = "org.springframework.boot.context.properties.bind.BindResult";

    @Bean
    LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer() {
        return new LocalVariableTableParameterNameDiscoverer();
    }

    @Bean
    @Lazy(value=false)
    AdditionalModelsConverter additionalModelsConverter() {
        return new AdditionalModelsConverter();
    }

    @Bean
    @Lazy(value=false)
    PropertyCustomizingConverter propertyCustomizingConverter(Optional<List<PropertyCustomizer>> customizers) {
        return new PropertyCustomizingConverter(customizers);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    FileSupportConverter fileSupportConverter() {
        return new FileSupportConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    ResponseSupportConverter responseSupportConverter() {
        return new ResponseSupportConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.model-converters.deprecating-converter.enabled"}, matchIfMissing=true)
    @Lazy(value=false)
    SchemaPropertyDeprecatingConverter schemaPropertyDeprecatingConverter() {
        return new SchemaPropertyDeprecatingConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    PolymorphicModelConverter polymorphicModelConverter() {
        return new PolymorphicModelConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    OpenAPIBuilder openAPIBuilder(Optional<OpenAPI> openAPI, ApplicationContext context, SecurityParser securityParser, SpringDocConfigProperties springDocConfigProperties, Optional<List<OpenApiBuilderCustomiser>> openApiBuilderCustomisers) {
        return new OpenAPIBuilder(openAPI, context, securityParser, springDocConfigProperties, openApiBuilderCustomisers);
    }

    @Bean
    @Lazy(value=false)
    ModelConverterRegistrar modelConverterRegistrar(Optional<List<ModelConverter>> modelConverters) {
        return new ModelConverterRegistrar(modelConverters.orElse(Collections.emptyList()));
    }

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnMissingBean
    OperationBuilder operationBuilder(GenericParameterBuilder parameterBuilder, RequestBodyBuilder requestBodyBuilder, SecurityParser securityParser, PropertyResolverUtils propertyResolverUtils) {
        return new OperationBuilder(parameterBuilder, requestBodyBuilder, securityParser, propertyResolverUtils);
    }

    @Bean
    PropertyResolverUtils propertyResolverUtils(ConfigurableBeanFactory factory) {
        return new PropertyResolverUtils(factory);
    }

    @Bean
    @ConditionalOnWebApplication
    @ConditionalOnMissingBean
    RequestBodyBuilder requestBodyBuilder(GenericParameterBuilder parameterBuilder) {
        return new RequestBodyBuilder(parameterBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    SecurityParser securityParser(PropertyResolverUtils propertyResolverUtils) {
        return new SecurityParser(propertyResolverUtils);
    }

    @Bean
    @Lazy(value=false)
    ReturnTypeParser genericReturnTypeParser() {
        return new ReturnTypeParser(){};
    }

    @Bean
    @ConditionalOnMissingBean
    GenericParameterBuilder parameterBuilder(PropertyResolverUtils propertyResolverUtils) {
        return new GenericParameterBuilder(propertyResolverUtils);
    }

    @Bean
    @ConditionalOnProperty(value={"springdoc.api-docs.resolve-schema-properties"})
    @Lazy(value=false)
    OpenApiCustomiser propertiesResolverForSchema(PropertyResolverUtils propertyResolverUtils, OpenAPIBuilder openAPIBuilder) {
        return openApi -> {
            Components components = openApi.getComponents();
            Map schemas = components.getSchemas();
            schemas.values().forEach(schema -> openAPIBuilder.resolveProperties((Schema)schema, propertyResolverUtils));
        };
    }

    @Bean
    @Conditional(value={CacheOrGroupedOpenApiCondition.class})
    @ConditionalOnClass(name={"org.springframework.boot.context.properties.bind.BindResult"})
    @Lazy(value=false)
    static BeanFactoryPostProcessor springdocBeanFactoryPostProcessor() {
        return new SpringdocBeanFactoryConfigurer();
    }

    @Bean
    @Conditional(value={CacheOrGroupedOpenApiCondition.class})
    @ConditionalOnMissingClass(value={"org.springframework.boot.context.properties.bind.BindResult"})
    @Lazy(value=false)
    static BeanFactoryPostProcessor springdocBeanFactoryPostProcessor2() {
        return SpringdocBeanFactoryConfigurer::initBeanFactoryPostProcessor;
    }

    static {
        SpringDocUtils.getConfig().replaceWithSchema(ObjectNode.class, (Schema)new ObjectSchema());
    }
}

