/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;

public class PropertyResolverUtils {
    private final ConfigurableBeanFactory factory;
    private final MessageSource messageSource;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyResolverUtils.class);

    public PropertyResolverUtils(ConfigurableBeanFactory factory, MessageSource messageSource) {
        this.factory = factory;
        this.messageSource = messageSource;
    }

    public String resolve(String parameterProperty, Locale locale) {
        try {
            return this.messageSource.getMessage(parameterProperty, null, locale);
        }
        catch (NoSuchMessageException ex) {
            LOGGER.trace(ex.getMessage());
            try {
                return this.factory.resolveEmbeddedValue(parameterProperty);
            }
            catch (IllegalArgumentException ex2) {
                LOGGER.warn(ex2.getMessage());
                return parameterProperty;
            }
        }
    }
}

