/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractSwaggerWelcome
implements InitializingBean {
    protected final SwaggerUiConfigProperties swaggerUiConfig;
    protected final SpringDocConfigProperties springDocConfigProperties;
    protected final SwaggerUiConfigParameters swaggerUiConfigParameters;
    protected String swaggerConfigUrl;
    protected String apiDocsUrl;

    public AbstractSwaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.springDocConfigProperties = springDocConfigProperties;
        this.swaggerUiConfigParameters = swaggerUiConfigParameters;
    }

    public void afterPropertiesSet() {
        this.springDocConfigProperties.getGroupConfigs().forEach(groupConfig -> this.swaggerUiConfigParameters.addGroup(groupConfig.getGroup()));
        this.calculateUiRootPath(new StringBuilder[0]);
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1) + docsUrl;
        }
        if (!docsUrl.startsWith("/")) {
            docsUrl = "/" + docsUrl;
        }
        return contextPath + docsUrl;
    }

    protected void buildConfigUrl(String contextPath, UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isEmpty((CharSequence)this.swaggerUiConfig.getConfigUrl())) {
            this.apiDocsUrl = (String)StringUtils.defaultIfEmpty((CharSequence)this.apiDocsUrl, (CharSequence)this.buildApiDocUrl(contextPath));
            this.swaggerConfigUrl = (String)StringUtils.defaultIfEmpty((CharSequence)this.swaggerConfigUrl, (CharSequence)this.buildSwaggerConfigUrl(contextPath));
            this.swaggerUiConfigParameters.setConfigUrl(this.swaggerConfigUrl);
            if (CollectionUtils.isEmpty(this.swaggerUiConfigParameters.getUrls())) {
                String swaggerUiUrl = this.swaggerUiConfig.getUrl();
                if (StringUtils.isEmpty((CharSequence)swaggerUiUrl)) {
                    this.swaggerUiConfigParameters.setUrl(this.apiDocsUrl);
                } else {
                    this.swaggerUiConfigParameters.setUrl(swaggerUiUrl);
                }
            } else {
                this.swaggerUiConfigParameters.addUrl(this.apiDocsUrl);
            }
        }
        this.calculateOauth2RedirectUrl(uriComponentsBuilder);
    }

    protected UriComponentsBuilder getUriComponentsBuilder(String sbUrl) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)sbUrl);
        if (this.swaggerUiConfig.isDisplayQueryParams() && StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfigParameters.getUrl())) {
            this.swaggerUiConfigParameters.getConfigParameters().entrySet().stream().filter(entry -> !"configUrl".equals(entry.getKey())).filter(entry -> !((String)entry.getKey()).startsWith("urls")).filter(entry -> StringUtils.isNotEmpty((CharSequence)((String)entry.getValue()))).forEach(entry -> uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()}));
        } else if (this.swaggerUiConfig.isDisplayQueryParamsWithoutOauth2() && StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfigParameters.getUrl())) {
            this.swaggerUiConfigParameters.getConfigParameters().entrySet().stream().filter(entry -> !"configUrl".equals(entry.getKey())).filter(entry -> !"oauth2RedirectUrl".equals(entry.getKey())).filter(entry -> !((String)entry.getKey()).startsWith("urls")).filter(entry -> StringUtils.isNotEmpty((CharSequence)((String)entry.getValue()))).forEach(entry -> uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()}));
        } else {
            uriBuilder.queryParam("configUrl", new Object[]{this.swaggerUiConfigParameters.getConfigUrl()});
            if (StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfigParameters.getLayout())) {
                uriBuilder.queryParam("layout", new Object[]{this.swaggerUiConfigParameters.getLayout()});
            }
            if (this.swaggerUiConfigParameters.getFilter() != null) {
                uriBuilder.queryParam("filter", new Object[]{this.swaggerUiConfigParameters.getFilter()});
            }
        }
        return uriBuilder;
    }

    protected abstract void calculateOauth2RedirectUrl(UriComponentsBuilder var1);

    protected abstract void calculateUiRootPath(StringBuilder ... var1);

    protected void calculateUiRootCommon(StringBuilder sbUrl, StringBuilder[] sbUrls) {
        String swaggerPath;
        if (ArrayUtils.isNotEmpty((Object[])sbUrls)) {
            sbUrl = sbUrls[0];
        }
        if ((swaggerPath = this.swaggerUiConfigParameters.getPath()).contains("/")) {
            sbUrl.append(swaggerPath, 0, swaggerPath.lastIndexOf("/"));
        }
        this.swaggerUiConfigParameters.setUiRootPath(sbUrl.toString());
    }

    protected String buildApiDocUrl(String contextPath) {
        return this.apiDocsUrl;
    }

    protected String buildSwaggerConfigUrl(String contextPath) {
        return this.swaggerConfigUrl;
    }

    protected String getOauth2RedirectUrl() {
        if (this.springDocConfigProperties.isCacheDisabled()) {
            return (String)StringUtils.defaultIfBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl(), (CharSequence)"/swagger-ui/oauth2-redirect.html");
        }
        return this.swaggerUiConfigParameters.getOauth2RedirectUrl();
    }
}

