/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.providers.ActuatorProvider;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.annotation.AbstractDiscoveredOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameter;
import org.springframework.boot.actuate.endpoint.invoke.reflect.OperationMethod;
import org.springframework.web.method.HandlerMethod;

public class ActuatorOperationCustomizer
implements OperationCustomizer {
    private HashMap<String, Integer> methodCountMap = new HashMap();
    private static final String OPERATION = "operation";
    private static final String PARAMETER = "parameter";
    private static final Logger LOGGER = LoggerFactory.getLogger(ActuatorOperationCustomizer.class);
    private static final Pattern pattern = Pattern.compile(".*'([^']*)'.*");

    @Override
    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        if (operation.getTags() != null && operation.getTags().contains(ActuatorProvider.getTag().getName())) {
            Field operationFiled = FieldUtils.getDeclaredField(handlerMethod.getBean().getClass(), (String)OPERATION, (boolean)true);
            if (operationFiled != null) {
                try {
                    Object actuatorOperation = operationFiled.get(handlerMethod.getBean());
                    operationFiled = FieldUtils.getDeclaredField(actuatorOperation.getClass(), (String)OPERATION, (boolean)true);
                    AbstractDiscoveredOperation discoveredOperation = (AbstractDiscoveredOperation)operationFiled.get(actuatorOperation);
                    OperationMethod operationMethod = discoveredOperation.getOperationMethod();
                    if (OperationType.WRITE.equals((Object)operationMethod.getOperationType())) {
                        for (OperationParameter operationParameter : operationMethod.getParameters()) {
                            Field parameterField = FieldUtils.getDeclaredField(operationParameter.getClass(), (String)PARAMETER, (boolean)true);
                            Parameter parameter = (Parameter)parameterField.get(operationParameter);
                            Schema schema = AnnotationsUtils.resolveSchemaFromType(parameter.getType(), null, null);
                            if (parameter.getAnnotation(Selector.class) != null) continue;
                            operation.setRequestBody(new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema(schema))));
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
            String summary = handlerMethod.toString();
            Matcher matcher = pattern.matcher(summary);
            String operationId = operation.getOperationId();
            while (matcher.find()) {
                operationId = matcher.group(1);
            }
            if (this.methodCountMap.containsKey(operationId)) {
                Integer methodCount = this.methodCountMap.get(operationId) + 1;
                this.methodCountMap.put(operationId, methodCount);
                operationId = operationId + "_" + methodCount;
            } else {
                this.methodCountMap.put(operationId, NumberUtils.INTEGER_ONE);
            }
            if (!summary.contains("$")) {
                operation.setSummary(summary);
            }
            operation.setOperationId(operationId);
        }
        return operation;
    }
}

