/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Iterator;
import org.springdoc.core.converters.Pageable;
import org.springframework.stereotype.Component;

@Component
class PageableSupportConverter
implements ModelConverter {
    private static final String PAGEABLE_TO_REPLACE = "org.springframework.data.domain.Pageable";
    private static final String PAGE_REQUEST_TO_REPLACE = "org.springframework.data.domain.PageRequest";
    private static final AnnotatedType PAGEABLE = new AnnotatedType(Pageable.class);

    PageableSupportConverter() {
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        String typeName = type.getType().getTypeName();
        if (PAGEABLE_TO_REPLACE.equals(typeName) || PAGE_REQUEST_TO_REPLACE.equals(typeName)) {
            type = PAGEABLE;
        }
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }
}

