/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest.core;

import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.fn.RouterOperation;
import org.springdoc.data.rest.DataRestHalProvider;
import org.springdoc.data.rest.core.ControllerType;
import org.springdoc.data.rest.core.DataRestOperationService;
import org.springdoc.data.rest.core.DataRestRepository;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.HttpMethods;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class DataRestRouterOperationService {
    private static final List<RequestMethod> UNDOCUMENTED_REQUEST_METHODS = Arrays.asList(RequestMethod.OPTIONS, RequestMethod.HEAD);
    private static final String REPOSITORY_PATH = "/{repository}";
    private static final String SEARCH_PATH = "/{search}";
    private static final String ID = "/{id}";
    private DataRestOperationService dataRestOperationService;
    private SpringDocConfigProperties springDocConfigProperties;

    public DataRestRouterOperationService(DataRestOperationService dataRestOperationService, SpringDocConfigProperties springDocConfigProperties, RepositoryRestConfiguration repositoryRestConfiguration, DataRestHalProvider dataRestHalProvider) {
        this.dataRestOperationService = dataRestOperationService;
        this.springDocConfigProperties = springDocConfigProperties;
        if (dataRestHalProvider.isHalEnabled()) {
            springDocConfigProperties.setDefaultProducesMediaType(repositoryRestConfiguration.getDefaultMediaType().toString());
        }
    }

    public void buildEntityRouterOperationList(List<RouterOperation> routerOperationList, Map<RequestMappingInfo, HandlerMethod> handlerMethodMap, ResourceMetadata resourceMetadata, DataRestRepository dataRestRepository, OpenAPI openAPI) {
        String path = resourceMetadata.getPath().toString();
        ControllerType controllerType = dataRestRepository.getControllerType();
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : handlerMethodMap.entrySet()) {
            this.buildRouterOperationList(routerOperationList, resourceMetadata, dataRestRepository, openAPI, path, entry, null, controllerType, null);
        }
    }

    public void buildSearchRouterOperationList(List<RouterOperation> routerOperationList, Map<RequestMappingInfo, HandlerMethod> handlerMethodMap, ResourceMetadata resourceMetadata, DataRestRepository dataRestRepository, OpenAPI openAPI, MethodResourceMapping methodResourceMapping) {
        String path = resourceMetadata.getPath().toString();
        Path subPath = methodResourceMapping.getPath();
        Optional<Map.Entry<RequestMappingInfo, HandlerMethod>> entryOptional = this.getSearchEntry(handlerMethodMap, dataRestRepository.getLocale());
        if (entryOptional.isPresent()) {
            Map.Entry<RequestMappingInfo, HandlerMethod> entry = entryOptional.get();
            this.buildRouterOperationList(routerOperationList, resourceMetadata, dataRestRepository, openAPI, path, entry, subPath.toString(), ControllerType.SEARCH, methodResourceMapping);
        }
    }

    private void buildRouterOperationList(List<RouterOperation> routerOperationList, ResourceMetadata resourceMetadata, DataRestRepository dataRestRepository, OpenAPI openAPI, String path, Map.Entry<RequestMappingInfo, HandlerMethod> entry, String subPath, ControllerType controllerType, MethodResourceMapping methodResourceMapping) {
        RequestMappingInfo requestMappingInfo = entry.getKey();
        HandlerMethod handlerMethod = entry.getValue();
        Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
        if (this.andCheck(resourceMetadata != null, !controllerType.equals((Object)ControllerType.SEARCH))) {
            HttpMethods httpMethodsItem = resourceMetadata.getSupportedHttpMethods().getMethodsFor(ResourceType.ITEM);
            Set<RequestMethod> requestMethodsItem = requestMethods.stream().filter(requestMethod -> httpMethodsItem.contains(HttpMethod.valueOf((String)requestMethod.toString()))).collect(Collectors.toSet());
            this.buildRouterOperation(routerOperationList, resourceMetadata, dataRestRepository, openAPI, path, subPath, controllerType, methodResourceMapping, requestMappingInfo, handlerMethod, requestMethodsItem, ResourceType.ITEM);
            if (!ControllerType.PROPERTY.equals((Object)controllerType)) {
                HttpMethods httpMethodsCollection = resourceMetadata.getSupportedHttpMethods().getMethodsFor(ResourceType.COLLECTION);
                Set<RequestMethod> requestMethodsCollection = requestMethods.stream().filter(requestMethod -> httpMethodsCollection.contains(HttpMethod.valueOf((String)requestMethod.toString()))).collect(Collectors.toSet());
                this.buildRouterOperation(routerOperationList, resourceMetadata, dataRestRepository, openAPI, path, subPath, controllerType, methodResourceMapping, requestMappingInfo, handlerMethod, requestMethodsCollection, ResourceType.COLLECTION);
            }
        } else {
            this.buildRouterOperation(routerOperationList, resourceMetadata, dataRestRepository, openAPI, path, subPath, controllerType, methodResourceMapping, requestMappingInfo, handlerMethod, requestMethods, null);
        }
    }

    private void buildRouterOperation(List<RouterOperation> routerOperationList, ResourceMetadata resourceMetadata, DataRestRepository dataRestRepository, OpenAPI openAPI, String path, String subPath, ControllerType controllerType, MethodResourceMapping methodResourceMapping, RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod, Set<RequestMethod> requestMethodsCollection, ResourceType collection) {
        if (!CollectionUtils.isEmpty(requestMethodsCollection)) {
            for (RequestMethod requestMethod : requestMethodsCollection) {
                String relationName;
                LinkedHashMap<String, String> regexMap;
                String operationPath;
                Set<String> patterns;
                if (UNDOCUMENTED_REQUEST_METHODS.contains(requestMethod) || CollectionUtils.isEmpty(patterns = this.getActivePatterns(requestMappingInfo)) || (operationPath = this.calculateOperationPath(path, subPath, patterns, regexMap = new LinkedHashMap<String, String>(), controllerType, relationName = dataRestRepository.getRelationName(), collection)) == null) continue;
                this.buildRouterOperation(routerOperationList, dataRestRepository, openAPI, methodResourceMapping, handlerMethod, requestMethod, resourceMetadata, operationPath, controllerType);
            }
        }
    }

    private String calculateOperationPath(String path, String subPath, Set<String> patterns, Map<String, String> regexMap, ControllerType controllerType, String relationName, ResourceType resourceType) {
        String operationPath = null;
        for (String pattern : patterns) {
            operationPath = PathUtils.parsePath((String)pattern, regexMap);
            operationPath = operationPath.replace(REPOSITORY_PATH, path);
            if (ControllerType.ENTITY.equals((Object)controllerType)) {
                if (!this.andCheck(ResourceType.ITEM.equals((Object)resourceType), !operationPath.endsWith(ID)) && !this.andCheck(ResourceType.COLLECTION.equals((Object)resourceType), operationPath.endsWith(ID))) continue;
                operationPath = null;
                continue;
            }
            if (ControllerType.SEARCH.equals((Object)controllerType)) {
                operationPath = operationPath.replace(SEARCH_PATH, subPath);
                continue;
            }
            if (!ControllerType.PROPERTY.equals((Object)controllerType)) continue;
            operationPath = operationPath.replace("{property}", relationName);
        }
        return operationPath;
    }

    private void buildRouterOperation(List<RouterOperation> routerOperationList, DataRestRepository dataRestRepository, OpenAPI openAPI, MethodResourceMapping methodResourceMapping, HandlerMethod handlerMethod, RequestMethod requestMethod, ResourceMetadata resourceMetadata, String operationPath, ControllerType controllerType) {
        RouterOperation routerOperation = new RouterOperation(operationPath, new RequestMethod[]{requestMethod});
        MethodAttributes methodAttributes = new MethodAttributes(this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType(), dataRestRepository.getLocale());
        methodAttributes.calculateConsumesProduces(handlerMethod.getMethod());
        routerOperation.setConsumes(methodAttributes.getMethodConsumes());
        routerOperation.setProduces(methodAttributes.getMethodProduces());
        Operation operation = this.dataRestOperationService.buildOperation(handlerMethod, dataRestRepository, openAPI, requestMethod, operationPath, methodAttributes, resourceMetadata, methodResourceMapping, controllerType);
        routerOperation.setOperationModel(operation);
        routerOperationList.add(routerOperation);
    }

    private Optional<Map.Entry<RequestMappingInfo, HandlerMethod>> getSearchEntry(Map<RequestMappingInfo, HandlerMethod> handlerMethodMap, Locale locale) {
        return handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)requestMappingInfoHandlerMethodEntry.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue();
            Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
            for (RequestMethod requestMethod : requestMethods) {
                if (!this.isSearchControllerPresent(requestMappingInfo, handlerMethod, requestMethod, locale)) continue;
                return true;
            }
            return false;
        }).findAny();
    }

    private boolean isSearchControllerPresent(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod, RequestMethod requestMethod, Locale locale) {
        Set<String> patterns;
        if (!UNDOCUMENTED_REQUEST_METHODS.contains(requestMethod) && !CollectionUtils.isEmpty(patterns = this.getActivePatterns(requestMappingInfo))) {
            LinkedHashMap regexMap = new LinkedHashMap();
            for (String pattern : patterns) {
                String operationPath = PathUtils.parsePath((String)pattern, regexMap);
                if (!this.andCheck(operationPath.contains(REPOSITORY_PATH), operationPath.contains(SEARCH_PATH))) continue;
                MethodAttributes methodAttributes = new MethodAttributes(this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType(), locale);
                methodAttributes.calculateConsumesProduces(handlerMethod.getMethod());
                if (!this.springDocConfigProperties.getDefaultProducesMediaType().equals(methodAttributes.getMethodProduces()[0])) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getActivePatterns(RequestMappingInfo requestMappingInfo) {
        Set patterns = null;
        PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
        if (patternsRequestCondition != null) {
            patterns = patternsRequestCondition.getPatterns();
        } else {
            PathPatternsRequestCondition pathPatternsRequestCondition = requestMappingInfo.getPathPatternsCondition();
            if (pathPatternsRequestCondition != null) {
                patterns = pathPatternsRequestCondition.getPatternValues();
            }
        }
        return patterns;
    }

    private boolean andCheck(boolean conditionOne, boolean conditionTwo) {
        return conditionOne && conditionTwo;
    }
}

