/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.HashMap;
import java.util.Map;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;

public class OperationIdCustomizer
implements GlobalOpenApiCustomizer {
    @Override
    public void customise(OpenAPI openApi) {
        HashMap<String, Integer> operationIdCount = new HashMap<String, Integer>();
        for (Map.Entry pathEntry : openApi.getPaths().entrySet()) {
            PathItem pathItem = (PathItem)pathEntry.getValue();
            this.processOperation(pathItem.getGet(), operationIdCount);
            this.processOperation(pathItem.getPost(), operationIdCount);
            this.processOperation(pathItem.getPut(), operationIdCount);
            this.processOperation(pathItem.getDelete(), operationIdCount);
            this.processOperation(pathItem.getPatch(), operationIdCount);
            this.processOperation(pathItem.getHead(), operationIdCount);
            this.processOperation(pathItem.getOptions(), operationIdCount);
            this.processOperation(pathItem.getTrace(), operationIdCount);
        }
    }

    private void processOperation(Operation operation, Map<String, Integer> operationIdCount) {
        if (operation != null) {
            String originalOperationId = operation.getOperationId();
            if (operationIdCount.containsKey(originalOperationId)) {
                int count = operationIdCount.get(originalOperationId);
                operationIdCount.put(originalOperationId, ++count);
                String newOperationId = originalOperationId + "_" + count;
                operation.setOperationId(newOperationId);
            } else {
                operationIdCount.put(originalOperationId, 0);
            }
        }
    }
}

