/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.versions;

import org.springdoc.core.versions.SpringDocVersionStrategy;
import org.springframework.http.MediaType;

public class MediaTypeVersionStrategy
extends SpringDocVersionStrategy {
    private final MediaType mediaType;
    private final String parameterName;

    public MediaTypeVersionStrategy(MediaType mediaType, String parameterName, String defaultVersion) {
        super(defaultVersion);
        this.mediaType = mediaType;
        this.parameterName = parameterName;
        if (defaultVersion != null) {
            this.versionDefaultMap.put(parameterName, defaultVersion);
        }
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String[] buildProduces() {
        String type = this.mediaType.getType();
        String subtype = this.mediaType.getSubtype();
        String produces = String.format("%s/%s;%s=%s", type, subtype, this.parameterName, this.version);
        return new String[]{produces};
    }
}

