/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import java.util.Optional;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.properties.SwaggerUiOAuthProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.webmvc.core.providers.SpringWebMvcProvider;
import org.springdoc.webmvc.ui.SwaggerConfigResource;
import org.springdoc.webmvc.ui.SwaggerIndexPageTransformer;
import org.springdoc.webmvc.ui.SwaggerIndexTransformer;
import org.springdoc.webmvc.ui.SwaggerResourceResolver;
import org.springdoc.webmvc.ui.SwaggerUiHome;
import org.springdoc.webmvc.ui.SwaggerWebMvcConfigurer;
import org.springdoc.webmvc.ui.SwaggerWelcomeActuator;
import org.springdoc.webmvc.ui.SwaggerWelcomeCommon;
import org.springdoc.webmvc.ui.SwaggerWelcomeWebMvc;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.webmvc.actuate.endpoint.web.WebMvcEndpointHandlerMapping;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerConfig {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.use-management-port"}, havingValue="false", matchIfMissing=true)
    @Lazy(value=false)
    SwaggerWelcomeWebMvc swaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SpringWebProvider springWebProvider) {
        return new SwaggerWelcomeWebMvc(swaggerUiConfig, springDocConfigProperties, springWebProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpringWebProvider springWebProvider() {
        return new SpringWebMvcProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.use-management-port"}, havingValue="false", matchIfMissing=true)
    @Lazy(value=false)
    SwaggerConfigResource swaggerConfigResource(SwaggerWelcomeCommon swaggerWelcomeCommon) {
        return new SwaggerConfigResource(swaggerWelcomeCommon);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.swagger-ui.use-root-path"}, havingValue="true")
    @Lazy(value=false)
    SwaggerUiHome swaggerUiHome() {
        return new SwaggerUiHome();
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SwaggerIndexTransformer indexPageTransformer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerUiOAuthProperties swaggerUiOAuthProperties, SwaggerWelcomeCommon swaggerWelcomeCommon, ObjectMapperProvider objectMapperProvider) {
        return new SwaggerIndexPageTransformer(swaggerUiConfig, swaggerUiOAuthProperties, swaggerWelcomeCommon, objectMapperProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SwaggerWebMvcConfigurer swaggerWebMvcConfigurer(SwaggerUiConfigProperties swaggerUiConfigProperties, SwaggerIndexTransformer swaggerIndexTransformer, Optional<ActuatorProvider> actuatorProvider, SwaggerResourceResolver swaggerResourceResolver) {
        return new SwaggerWebMvcConfigurer(swaggerUiConfigProperties, swaggerIndexTransformer, actuatorProvider, swaggerResourceResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SwaggerResourceResolver swaggerResourceResolver(SwaggerUiConfigProperties swaggerUiConfigProperties) {
        return new SwaggerResourceResolver(swaggerUiConfigProperties);
    }

    @ConditionalOnProperty(value={"springdoc.use-management-port"})
    @ConditionalOnClass(value={WebMvcEndpointHandlerMapping.class})
    @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
    static class SwaggerActuatorWelcomeConfiguration {
        SwaggerActuatorWelcomeConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        SwaggerWelcomeActuator swaggerActuatorWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, WebEndpointProperties webEndpointProperties) {
            return new SwaggerWelcomeActuator(swaggerUiConfig, springDocConfigProperties, webEndpointProperties);
        }
    }
}

