/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.core.SwaggerUiOAuthProperties;
import org.springdoc.ui.AbstractSwaggerIndexTransformer;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

public class SwaggerIndexTransformer
extends AbstractSwaggerIndexTransformer
implements ResourceTransformer {
    public SwaggerIndexTransformer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerUiOAuthProperties swaggerUiOAuthProperties, ObjectMapper objectMapper) {
        super(swaggerUiConfig, swaggerUiOAuthProperties, objectMapper);
    }

    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        boolean isIndexFound = antPathMatcher.match("**/swagger-ui/**/index.html", resource.getURL().toString());
        if (isIndexFound && !CollectionUtils.isEmpty((Map)this.swaggerUiOAuthProperties.getConfigParameters()) && this.swaggerUiConfig.isDisableSwaggerDefaultUrl()) {
            String html = this.readFullyAsString(resource.getInputStream());
            html = this.addInitOauth(html);
            html = this.overwriteSwaggerDefaultUrl(html);
            return new TransformedResource(resource, html.getBytes());
        }
        if (isIndexFound && !CollectionUtils.isEmpty((Map)this.swaggerUiOAuthProperties.getConfigParameters())) {
            String html = this.readFullyAsString(resource.getInputStream());
            html = this.addInitOauth(html);
            return new TransformedResource(resource, html.getBytes());
        }
        if (isIndexFound && this.swaggerUiConfig.isDisableSwaggerDefaultUrl()) {
            String html = this.readFullyAsString(resource.getInputStream());
            html = this.overwriteSwaggerDefaultUrl(html);
            return new TransformedResource(resource, html.getBytes());
        }
        return resource;
    }
}

