/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import io.swagger.v3.oas.annotations.Operation;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.webmvc.api.OpenApiWebMvcResource;
import org.springdoc.webmvc.ui.SwaggerWelcomeCommon;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class SwaggerWelcomeWebMvc
extends SwaggerWelcomeCommon {
    @Value(value="${spring.mvc.servlet.path:#{null}}")
    private String mvcServletPath;
    private String pathPrefix;
    private final ApplicationContext applicationContext;

    public SwaggerWelcomeWebMvc(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, ApplicationContext applicationContext) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        this.applicationContext = applicationContext;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public ResponseEntity<Void> redirectToUi(HttpServletRequest request) {
        return super.redirectToUi(request);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            sbUrl.append(this.mvcServletPath);
        }
        this.calculateUiRootCommon(sbUrl, sbUrls);
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            contextPath = contextPath + this.mvcServletPath;
        }
        return super.buildUrl(contextPath, docsUrl);
    }

    protected String buildApiDocUrl() {
        if (this.pathPrefix == null) {
            this.pathPrefix = OpenApiWebMvcResource.findPathPrefix((ApplicationContext)this.applicationContext, (SpringDocConfigProperties)this.springDocConfigProperties);
        }
        return this.buildUrl(this.contextPath + this.pathPrefix, this.springDocConfigProperties.getApiDocs().getPath());
    }

    protected String buildSwaggerConfigUrl() {
        return this.apiDocsUrl + "/" + "swagger-config";
    }
}

