/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.AbstractRequestService;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.RepositoryRestResourceProvider;
import org.springdoc.core.SecurityOAuth2Provider;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.webmvc.core.RouterFunctionProvider;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

public abstract class OpenApiResource
extends AbstractOpenApiResource {
    private final RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    private final Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider;
    private final Optional<RouterFunctionProvider> routerFunctionProvider;
    private final Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider;

    public OpenApiResource(String groupName, ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> actuatorProvider, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider, Optional<RouterFunctionProvider> routerFunctionProvider, Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider) {
        super(groupName, openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, springDocConfigProperties, actuatorProvider);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.springSecurityOAuth2Provider = springSecurityOAuth2Provider;
        this.routerFunctionProvider = routerFunctionProvider;
        this.repositoryRestResourceProvider = repositoryRestResourceProvider;
    }

    public OpenApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> actuatorProvider, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider, Optional<RouterFunctionProvider> routerFunctionProvider, Optional<RepositoryRestResourceProvider> repositoryRestResourceProvider) {
        super("springdocDefault", openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, springDocConfigProperties, actuatorProvider);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.springSecurityOAuth2Provider = springSecurityOAuth2Provider;
        this.routerFunctionProvider = routerFunctionProvider;
        this.repositoryRestResourceProvider = repositoryRestResourceProvider;
    }

    public String openapiJson(HttpServletRequest request, String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return this.writeJsonValue(openAPI);
    }

    public String openapiYaml(HttpServletRequest request, String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return this.writeYamlValue(openAPI);
    }

    protected void getPaths(Map<String, Object> restControllers) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        this.calculatePath(restControllers, map);
        if (this.isShowActuator()) {
            map = ((ActuatorProvider)this.optionalActuatorProvider.get()).getMethods();
            this.openAPIService.addTag(new HashSet(map.values()), ActuatorProvider.getTag());
            this.calculatePath(restControllers, map);
        }
        if (this.springSecurityOAuth2Provider.isPresent()) {
            SecurityOAuth2Provider securityOAuth2Provider = this.springSecurityOAuth2Provider.get();
            Map mapOauth = securityOAuth2Provider.getHandlerMethods();
            Map requestMappingMapSec = securityOAuth2Provider.getFrameworkEndpoints();
            Class[] additionalRestClasses = (Class[])requestMappingMapSec.values().stream().map(Object::getClass).toArray(Class[]::new);
            AbstractOpenApiResource.addRestControllers((Class[])additionalRestClasses);
            this.calculatePath(requestMappingMapSec, mapOauth);
        }
        this.routerFunctionProvider.ifPresent(routerFunctions -> routerFunctions.getWebMvcRouterFunctionPaths().ifPresent(routerBeans -> routerBeans.forEach((arg_0, arg_1) -> ((OpenApiResource)this).getRouterFunctionPaths(arg_0, arg_1))));
        if (this.repositoryRestResourceProvider.isPresent()) {
            RepositoryRestResourceProvider restResourceProvider = this.repositoryRestResourceProvider.get();
            List operationList = restResourceProvider.getRouterOperations(this.openAPIService.getCalculatedOpenAPI());
            this.calculatePath(operationList);
        }
    }

    protected void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map) {
        ArrayList<Map.Entry<RequestMappingInfo, HandlerMethod>> entries = new ArrayList<Map.Entry<RequestMappingInfo, HandlerMethod>>(map.entrySet());
        entries.sort(this.byReversedRequestMappingInfos());
        for (Map.Entry entry : entries) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            Set<String> patterns = this.getActivePatterns(requestMappingInfo);
            if (CollectionUtils.isEmpty(patterns)) continue;
            LinkedHashMap regexMap = new LinkedHashMap();
            for (String pattern : patterns) {
                String operationPath = PathUtils.parsePath((String)pattern, regexMap);
                String[] produces = (String[])requestMappingInfo.getProducesCondition().getProducibleMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                String[] consumes = (String[])requestMappingInfo.getConsumesCondition().getConsumableMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                String[] headers = (String[])requestMappingInfo.getHeadersCondition().getExpressions().stream().map(Object::toString).toArray(String[]::new);
                if ((!this.isShowActuator() || !((ActuatorProvider)this.optionalActuatorProvider.get()).isRestController(operationPath, handlerMethod.getBeanType())) && !this.isRestController(restControllers, handlerMethod, operationPath) || !this.isFilterCondition(handlerMethod, operationPath, produces, consumes, headers)) continue;
                Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                if (requestMethods.isEmpty()) {
                    requestMethods = this.getDefaultAllowedHttpMethods();
                }
                this.calculatePath(handlerMethod, operationPath, requestMethods);
            }
        }
    }

    private Set<String> getActivePatterns(RequestMappingInfo requestMappingInfo) {
        Set patterns = null;
        PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
        if (patternsRequestCondition != null) {
            patterns = patternsRequestCondition.getPatterns();
        } else {
            PathPatternsRequestCondition pathPatternsRequestCondition = requestMappingInfo.getPathPatternsCondition();
            if (pathPatternsRequestCondition != null) {
                patterns = pathPatternsRequestCondition.getPatternValues();
            }
        }
        return patterns;
    }

    private Comparator<Map.Entry<RequestMappingInfo, HandlerMethod>> byReversedRequestMappingInfos() {
        return Comparator.comparing(a -> ((RequestMappingInfo)a.getKey()).toString()).reversed();
    }

    protected boolean isRestController(Map<String, Object> restControllers, HandlerMethod handlerMethod, String operationPath) {
        boolean hasOperationAnnotation = AnnotatedElementUtils.hasAnnotation((AnnotatedElement)handlerMethod.getMethod(), Operation.class);
        if (hasOperationAnnotation) {
            return true;
        }
        ResponseBody responseBodyAnnotation = (ResponseBody)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), ResponseBody.class);
        if (responseBodyAnnotation == null) {
            responseBodyAnnotation = (ResponseBody)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), ResponseBody.class);
        }
        return (responseBodyAnnotation != null && restControllers.containsKey(handlerMethod.getBean().toString()) || this.isAdditionalRestController(handlerMethod.getBeanType())) && operationPath.startsWith("/") && (this.springDocConfigProperties.isModelAndViewAllowed() || !ModelAndView.class.isAssignableFrom(handlerMethod.getMethod().getReturnType()));
    }

    protected void calculateServerUrl(HttpServletRequest request, String apiDocsUrl) {
        super.initOpenAPIBuilder();
        String calculatedUrl = this.getServerUrl(request, apiDocsUrl);
        this.openAPIService.setServerBaseUrl(calculatedUrl);
    }

    protected abstract String getServerUrl(HttpServletRequest var1, String var2);
}

