/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.transport.WebMvcStreamableServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerAutoConfiguration;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerStdioDisabledCondition;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerProperties;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerStreamableHttpProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.servlet.function.RouterFunction;

@AutoConfiguration(before={McpServerAutoConfiguration.class})
@ConditionalOnClass(value={McpSchema.class})
@EnableConfigurationProperties(value={McpServerProperties.class, McpServerStreamableHttpProperties.class})
@Conditional(value={McpServerStdioDisabledCondition.class, McpServerAutoConfiguration.EnabledStreamableServerCondition.class})
public class McpServerStreamableHttpWebMvcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WebMvcStreamableServerTransportProvider webMvcStreamableServerTransportProvider(ObjectProvider<ObjectMapper> objectMapperProvider, McpServerStreamableHttpProperties serverProperties) {
        ObjectMapper objectMapper = (ObjectMapper)objectMapperProvider.getIfAvailable(ObjectMapper::new);
        return WebMvcStreamableServerTransportProvider.builder().objectMapper(objectMapper).mcpEndpoint(serverProperties.getMcpEndpoint()).keepAliveInterval(serverProperties.getKeepAliveInterval()).disallowDelete(serverProperties.isDisallowDelete()).build();
    }

    @Bean
    public RouterFunction<?> webMvcStreamableServerRouterFunction(WebMvcStreamableServerTransportProvider webMvcProvider) {
        return webMvcProvider.getRouterFunction();
    }
}

