/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.mistralai.autoconfigure;

import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.ai.mistralai.api.MistralAiModerationApi;
import org.springframework.ai.mistralai.moderation.MistralAiModerationModel;
import org.springframework.ai.model.mistralai.autoconfigure.MistralAiCommonProperties;
import org.springframework.ai.model.mistralai.autoconfigure.MistralAiModerationProperties;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class, WebClientAutoConfiguration.class})
@EnableConfigurationProperties(value={MistralAiCommonProperties.class, MistralAiModerationProperties.class})
@ConditionalOnProperty(name={"spring.ai.model.moderation"}, havingValue="mistral", matchIfMissing=true)
@ConditionalOnClass(value={MistralAiApi.class})
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class, RestClientAutoConfiguration.class, WebClientAutoConfiguration.class})
public class MistralAiModerationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MistralAiModerationModel mistralAiModerationModel(MistralAiCommonProperties commonProperties, MistralAiModerationProperties moderationProperties, RetryTemplate retryTemplate, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ResponseErrorHandler responseErrorHandler) {
        String apiKey = moderationProperties.getApiKey();
        String baseUrl = moderationProperties.getBaseUrl();
        String resolvedApiKey = StringUtils.hasText((String)apiKey) ? apiKey : commonProperties.getApiKey();
        String resoledBaseUrl = StringUtils.hasText((String)baseUrl) ? baseUrl : commonProperties.getBaseUrl();
        Assert.hasText((String)resolvedApiKey, (String)"Mistral API key must be set");
        Assert.hasText((String)resoledBaseUrl, (String)"Mistral base URL must be set");
        MistralAiModerationApi mistralAiModerationApi = MistralAiModerationApi.builder().baseUrl(resoledBaseUrl).apiKey(resolvedApiKey).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).responseErrorHandler(responseErrorHandler).build();
        return MistralAiModerationModel.builder().mistralAiModerationApi(mistralAiModerationApi).retryTemplate(retryTemplate).options(moderationProperties.getOptions()).build();
    }
}

