/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.ai.chat.client.ChatClientAttributes;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.client.observation.ChatClientObservationDocumentation;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.observation.tracing.TracingHelper;
import org.springframework.util.CollectionUtils;

@Deprecated
public class ChatClientInputContentObservationFilter
implements ObservationFilter {
    public Observation.Context map(Observation.Context context) {
        if (!(context instanceof ChatClientObservationContext)) {
            return context;
        }
        ChatClientObservationContext chatClientObservationContext = (ChatClientObservationContext)context;
        this.chatClientSystemText(chatClientObservationContext);
        this.chatClientSystemParams(chatClientObservationContext);
        this.chatClientUserText(chatClientObservationContext);
        this.chatClientUserParams(chatClientObservationContext);
        return chatClientObservationContext;
    }

    protected void chatClientSystemText(ChatClientObservationContext context) {
        List messages = context.getRequest().prompt().getInstructions();
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return;
        }
        Optional<Message> systemMessage = messages.stream().filter(message -> message instanceof SystemMessage).reduce((first, second) -> second);
        if (systemMessage.isEmpty()) {
            return;
        }
        context.addHighCardinalityKeyValue(KeyValue.of((KeyName)ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_SYSTEM_TEXT, (String)systemMessage.get().getText()));
    }

    protected void chatClientSystemParams(ChatClientObservationContext context) {
        Object object = context.getRequest().context().get(ChatClientAttributes.SYSTEM_PARAMS.getKey());
        if (!(object instanceof Map)) {
            return;
        }
        Map systemParams = (Map)object;
        if (CollectionUtils.isEmpty((Map)systemParams)) {
            return;
        }
        context.addHighCardinalityKeyValue(KeyValue.of((KeyName)ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_SYSTEM_PARAM, (String)TracingHelper.concatenateMaps((Map)systemParams)));
    }

    protected void chatClientUserText(ChatClientObservationContext context) {
        List messages = context.getRequest().prompt().getInstructions();
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return;
        }
        Object e = messages.get(messages.size() - 1);
        if (!(e instanceof UserMessage)) {
            return;
        }
        UserMessage userMessage = (UserMessage)e;
        context.addHighCardinalityKeyValue(KeyValue.of((KeyName)ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_USER_TEXT, (String)userMessage.getText()));
    }

    protected void chatClientUserParams(ChatClientObservationContext context) {
        Object object = context.getRequest().context().get(ChatClientAttributes.USER_PARAMS.getKey());
        if (!(object instanceof Map)) {
            return;
        }
        Map userParams = (Map)object;
        if (CollectionUtils.isEmpty((Map)userParams)) {
            return;
        }
        context.addHighCardinalityKeyValue(KeyValue.of((KeyName)ChatClientObservationDocumentation.HighCardinalityKeyNames.CHAT_CLIENT_USER_PARAMS, (String)TracingHelper.concatenateMaps((Map)userParams)));
    }
}

