/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.mcp.McpConnectionInfo;
import org.springframework.ai.mcp.McpToolFilter;
import org.springframework.ai.mcp.McpToolNamePrefixGenerator;
import org.springframework.ai.mcp.SyncMcpToolCallback;
import org.springframework.ai.mcp.ToolContextToMcpMetaConverter;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.support.ToolUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SyncMcpToolCallbackProvider
implements ToolCallbackProvider {
    private final List<McpSyncClient> mcpClients;
    private final McpToolFilter toolFilter;
    private McpToolNamePrefixGenerator toolNamePrefixGenerator;
    private final ToolContextToMcpMetaConverter toolContextToMcpMetaConverter;

    @Deprecated
    public SyncMcpToolCallbackProvider(McpToolFilter toolFilter, List<McpSyncClient> mcpClients) {
        this(toolFilter, McpToolNamePrefixGenerator.defaultGenerator(), mcpClients, ToolContextToMcpMetaConverter.defaultConverter());
    }

    private SyncMcpToolCallbackProvider(McpToolFilter toolFilter, McpToolNamePrefixGenerator toolNamePrefixGenerator, List<McpSyncClient> mcpClients, ToolContextToMcpMetaConverter toolContextToMcpMetaConverter) {
        Assert.notNull(mcpClients, (String)"MCP clients must not be null");
        Assert.notNull((Object)toolFilter, (String)"Tool filter must not be null");
        Assert.notNull((Object)toolNamePrefixGenerator, (String)"Tool name prefix generator must not be null");
        Assert.notNull((Object)toolContextToMcpMetaConverter, (String)"Tool context to MCP meta converter must not be null");
        this.mcpClients = mcpClients;
        this.toolFilter = toolFilter;
        this.toolNamePrefixGenerator = toolNamePrefixGenerator;
        this.toolContextToMcpMetaConverter = toolContextToMcpMetaConverter;
    }

    @Deprecated
    public SyncMcpToolCallbackProvider(List<McpSyncClient> mcpClients) {
        this((mcpClient, tool) -> true, mcpClients);
    }

    @Deprecated
    public SyncMcpToolCallbackProvider(McpToolFilter toolFilter, McpToolNamePrefixGenerator toolNamePrefixGenerator, McpSyncClient ... mcpClients) {
        this(toolFilter, toolNamePrefixGenerator, List.of(mcpClients), ToolContextToMcpMetaConverter.defaultConverter());
    }

    @Deprecated
    public SyncMcpToolCallbackProvider(McpSyncClient ... mcpClients) {
        this(List.of(mcpClients));
    }

    public ToolCallback[] getToolCallbacks() {
        ToolCallback[] array = (ToolCallback[])this.mcpClients.stream().flatMap(mcpClient -> mcpClient.listTools().tools().stream().filter(tool -> this.toolFilter.test(SyncMcpToolCallbackProvider.connectionInfo(mcpClient), tool)).map(tool -> SyncMcpToolCallback.builder().mcpClient((McpSyncClient)mcpClient).tool((McpSchema.Tool)tool).prefixedToolName(this.toolNamePrefixGenerator.prefixedToolName(SyncMcpToolCallbackProvider.connectionInfo(mcpClient), (McpSchema.Tool)tool)).toolContextToMcpMetaConverter(this.toolContextToMcpMetaConverter).build())).toArray(ToolCallback[]::new);
        this.validateToolCallbacks(array);
        return array;
    }

    private static McpConnectionInfo connectionInfo(McpSyncClient mcpClient) {
        return McpConnectionInfo.builder().clientCapabilities(mcpClient.getClientCapabilities()).clientInfo(mcpClient.getClientInfo()).initializeResult(mcpClient.getCurrentInitializationResult()).build();
    }

    private void validateToolCallbacks(ToolCallback[] toolCallbacks) {
        List duplicateToolNames = ToolUtils.getDuplicateToolNames((ToolCallback[])toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s)".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }

    public static List<ToolCallback> syncToolCallbacks(List<McpSyncClient> mcpClients) {
        if (CollectionUtils.isEmpty(mcpClients)) {
            return List.of();
        }
        return List.of(new SyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<McpSyncClient> mcpClients = new ArrayList<McpSyncClient>();
        private McpToolFilter toolFilter = (mcpClient, tool) -> true;
        private McpToolNamePrefixGenerator toolNamePrefixGenerator = McpToolNamePrefixGenerator.defaultGenerator();
        private ToolContextToMcpMetaConverter toolContextToMcpMetaConverter = ToolContextToMcpMetaConverter.defaultConverter();

        public Builder mcpClients(List<McpSyncClient> mcpClients) {
            Assert.notNull(mcpClients, (String)"MCP clients list must not be null");
            this.mcpClients = new ArrayList<McpSyncClient>(mcpClients);
            return this;
        }

        public Builder mcpClients(McpSyncClient ... mcpClients) {
            Assert.notNull((Object)mcpClients, (String)"MCP clients array must not be null");
            this.mcpClients = new ArrayList<McpSyncClient>(List.of(mcpClients));
            return this;
        }

        public Builder addMcpClient(McpSyncClient mcpClient) {
            Assert.notNull((Object)mcpClient, (String)"MCP client must not be null");
            this.mcpClients.add(mcpClient);
            return this;
        }

        public Builder toolFilter(McpToolFilter toolFilter) {
            Assert.notNull((Object)toolFilter, (String)"Tool filter must not be null");
            this.toolFilter = toolFilter;
            return this;
        }

        public Builder toolNamePrefixGenerator(McpToolNamePrefixGenerator toolNamePrefixGenerator) {
            Assert.notNull((Object)toolNamePrefixGenerator, (String)"Tool name prefix generator must not be null");
            this.toolNamePrefixGenerator = toolNamePrefixGenerator;
            return this;
        }

        public Builder toolContextToMcpMetaConverter(ToolContextToMcpMetaConverter toolContextToMcpMetaConverter) {
            Assert.notNull((Object)toolContextToMcpMetaConverter, (String)"Tool context to MCP meta converter must not be null");
            this.toolContextToMcpMetaConverter = toolContextToMcpMetaConverter;
            return this;
        }

        public SyncMcpToolCallbackProvider build() {
            return new SyncMcpToolCallbackProvider(this.toolFilter, this.toolNamePrefixGenerator, this.mcpClients, this.toolContextToMcpMetaConverter);
        }
    }
}

