/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.utils.SerializationUtils;

public class Message
implements Serializable {
    private static final long serialVersionUID = -7177590352110605597L;
    private static final String ENCODING = Charset.defaultCharset().name();
    private final MessageProperties messageProperties;
    private final byte[] body;

    public Message(byte[] body, MessageProperties messageProperties) {
        this.body = body;
        this.messageProperties = messageProperties;
    }

    public byte[] getBody() {
        return this.body;
    }

    public MessageProperties getMessageProperties() {
        return this.messageProperties;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append("Body:'" + this.getBodyContentAsString() + "'");
        if (this.messageProperties != null) {
            buffer.append("; ID:" + this.messageProperties.getMessageId());
            buffer.append("; Content:" + this.messageProperties.getContentType());
            buffer.append("; Headers:" + this.messageProperties.getHeaders());
            buffer.append("; Exchange:" + this.messageProperties.getReceivedExchange());
            buffer.append("; RoutingKey:" + this.messageProperties.getReceivedRoutingKey());
            buffer.append("; Reply:" + this.messageProperties.getReplyTo());
            buffer.append("; DeliveryMode:" + (Object)((Object)this.messageProperties.getDeliveryMode()));
            buffer.append("; DeliveryTag:" + this.messageProperties.getDeliveryTag());
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String getBodyContentAsString() {
        if (this.body == null) {
            return null;
        }
        try {
            String contentType;
            String string = contentType = this.messageProperties != null ? this.messageProperties.getContentType() : null;
            if ("application/x-java-serialized-object".equals(contentType)) {
                return SerializationUtils.deserialize(this.body).toString();
            }
            if ("text/plain".equals(contentType)) {
                return new String(this.body, ENCODING);
            }
            if ("application/json".equals(contentType)) {
                return new String(this.body, ENCODING);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.body.toString() + "(byte[" + this.body.length + "])";
    }
}

