/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.lang.reflect.Type;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractJavaTypeMapper;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.util.ClassUtils;

public class DefaultJavaTypeMapper
extends AbstractJavaTypeMapper
implements JavaTypeMapper,
ClassMapper {
    @Override
    public JavaType toJavaType(MessageProperties properties) {
        JavaType classType = this.getClassIdType(this.retrieveHeader(properties, this.getClassIdFieldName()));
        if (!classType.isContainerType() || classType.isArrayType()) {
            return classType;
        }
        JavaType contentClassType = this.getClassIdType(this.retrieveHeader(properties, this.getContentClassIdFieldName()));
        if (classType.getKeyType() == null) {
            return CollectionType.construct((Class)classType.getRawClass(), (JavaType)contentClassType);
        }
        JavaType keyClassType = this.getClassIdType(this.retrieveHeader(properties, this.getKeyClassIdFieldName()));
        return MapType.construct((Class)classType.getRawClass(), (JavaType)keyClassType, (JavaType)contentClassType);
    }

    private JavaType getClassIdType(String classId) {
        if (this.getIdClassMapping().containsKey(classId)) {
            return TypeFactory.defaultInstance().constructType((Type)this.getIdClassMapping().get(classId));
        }
        try {
            return TypeFactory.defaultInstance().constructType((Type)ClassUtils.forName((String)classId, (ClassLoader)this.getClass().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new MessageConversionException("failed to resolve class name. Class not found [" + classId + "]", e);
        }
        catch (LinkageError e) {
            throw new MessageConversionException("failed to resolve class name. Linkage error [" + classId + "]", e);
        }
    }

    @Override
    public void fromJavaType(JavaType javaType, MessageProperties properties) {
        this.addHeader(properties, this.getClassIdFieldName(), javaType.getRawClass());
        if (javaType.isContainerType() && !javaType.isArrayType()) {
            this.addHeader(properties, this.getContentClassIdFieldName(), javaType.getContentType().getRawClass());
        }
        if (javaType.getKeyType() != null) {
            this.addHeader(properties, this.getKeyClassIdFieldName(), javaType.getKeyType().getRawClass());
        }
    }

    @Override
    public void fromClass(Class<?> clazz, MessageProperties properties) {
        this.fromJavaType(TypeFactory.defaultInstance().constructType(clazz), properties);
    }

    @Override
    public Class<?> toClass(MessageProperties properties) {
        return this.toJavaType(properties).getRawClass();
    }
}

