/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractJavaTypeMapper;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.Jackson2JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultJackson2JavaTypeMapper
extends AbstractJavaTypeMapper
implements Jackson2JavaTypeMapper,
ClassMapper {
    private volatile Jackson2JavaTypeMapper.TypePrecedence typePrecedence = Jackson2JavaTypeMapper.TypePrecedence.INFERRED;

    @Override
    public Jackson2JavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.typePrecedence;
    }

    public void setTypePrecedence(Jackson2JavaTypeMapper.TypePrecedence typePrecedence) {
        Assert.notNull((Object)((Object)typePrecedence), (String)"'typePrecedence' cannot be null");
        this.typePrecedence = typePrecedence;
    }

    @Override
    public JavaType toJavaType(MessageProperties properties) {
        JavaType targetType;
        boolean hasInferredTypeHeader = this.hasInferredTypeHeader(properties);
        if (hasInferredTypeHeader && this.typePrecedence.equals((Object)Jackson2JavaTypeMapper.TypePrecedence.INFERRED) && (!(targetType = this.fromInferredTypeHeader(properties)).isAbstract() && !targetType.isInterface() || targetType.getRawClass().getPackage().getName().startsWith("java.util"))) {
            return targetType;
        }
        String typeIdHeader = this.retrieveHeaderAsString(properties, this.getClassIdFieldName());
        if (typeIdHeader != null) {
            JavaType classType = this.getClassIdType(typeIdHeader);
            if (!classType.isContainerType() || classType.isArrayType()) {
                return classType;
            }
            JavaType contentClassType = this.getClassIdType(this.retrieveHeader(properties, this.getContentClassIdFieldName()));
            if (classType.getKeyType() == null) {
                return CollectionType.construct((Class)classType.getRawClass(), (JavaType)contentClassType);
            }
            JavaType keyClassType = this.getClassIdType(this.retrieveHeader(properties, this.getKeyClassIdFieldName()));
            return MapType.construct((Class)classType.getRawClass(), (JavaType)keyClassType, (JavaType)contentClassType);
        }
        if (hasInferredTypeHeader) {
            return this.fromInferredTypeHeader(properties);
        }
        return TypeFactory.defaultInstance().constructType(Object.class);
    }

    private JavaType getClassIdType(String classId) {
        if (this.getIdClassMapping().containsKey(classId)) {
            return TypeFactory.defaultInstance().constructType((Type)this.getIdClassMapping().get(classId));
        }
        try {
            return TypeFactory.defaultInstance().constructType((Type)ClassUtils.forName((String)classId, (ClassLoader)this.getClass().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new MessageConversionException("failed to resolve class name. Class not found [" + classId + "]", e);
        }
        catch (LinkageError e) {
            throw new MessageConversionException("failed to resolve class name. Linkage error [" + classId + "]", e);
        }
    }

    @Override
    public void fromJavaType(JavaType javaType, MessageProperties properties) {
        this.addHeader(properties, this.getClassIdFieldName(), javaType.getRawClass());
        if (javaType.isContainerType() && !javaType.isArrayType()) {
            this.addHeader(properties, this.getContentClassIdFieldName(), javaType.getContentType().getRawClass());
        }
        if (javaType.getKeyType() != null) {
            this.addHeader(properties, this.getKeyClassIdFieldName(), javaType.getKeyType().getRawClass());
        }
    }

    @Override
    public void fromClass(Class<?> clazz, MessageProperties properties) {
        this.fromJavaType(TypeFactory.defaultInstance().constructType(clazz), properties);
    }

    @Override
    public Class<?> toClass(MessageProperties properties) {
        return this.toJavaType(properties).getRawClass();
    }
}

