/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.remoting.service;

import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedExporter;
import org.springframework.remoting.support.RemoteInvocationResult;

public class AmqpInvokerServiceExporter
extends RemoteInvocationBasedExporter
implements MessageListener {
    private AmqpTemplate amqpTemplate;
    private MessageConverter messageConverter = new SimpleMessageConverter();

    @Override
    public void onMessage(Message message) {
        RemoteInvocationResult remoteInvocationResult;
        Address replyToAddress = message.getMessageProperties().getReplyToAddress();
        if (replyToAddress == null) {
            throw new AmqpRejectAndDontRequeueException("No replyToAddress in inbound AMQP Message");
        }
        Object invocationRaw = this.messageConverter.fromMessage(message);
        if (invocationRaw == null || !(invocationRaw instanceof RemoteInvocation)) {
            remoteInvocationResult = new RemoteInvocationResult((Throwable)new IllegalArgumentException("The message does not contain a RemoteInvocation payload"));
        } else {
            RemoteInvocation invocation = (RemoteInvocation)invocationRaw;
            remoteInvocationResult = this.invokeAndCreateResult(invocation, this.getService());
        }
        this.send(remoteInvocationResult, replyToAddress);
    }

    private void send(Object object, Address replyToAddress) {
        Message message = this.messageConverter.toMessage(object, new MessageProperties());
        this.getAmqpTemplate().send(replyToAddress.getExchangeName(), replyToAddress.getRoutingKey(), message);
    }

    public AmqpTemplate getAmqpTemplate() {
        return this.amqpTemplate;
    }

    public void setAmqpTemplate(AmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }
}

