/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.springframework.amqp.core.NamingStrategy;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;

public class Base64UrlNamingStrategy
implements NamingStrategy {
    public static final Base64UrlNamingStrategy DEFAULT = new Base64UrlNamingStrategy();
    private final String prefix;

    public Base64UrlNamingStrategy() {
        this("spring.gen-");
    }

    public Base64UrlNamingStrategy(String prefix) {
        Assert.notNull((Object)prefix, (String)"'prefix' cannot be null; use an empty String ");
        this.prefix = prefix;
    }

    @Override
    public String generateName() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return this.prefix + Base64Utils.encodeToUrlSafeString((byte[])bb.array()).replaceAll("=", "");
    }
}

