/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.postprocessor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.core.Ordered;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractCompressingPostProcessor
implements MessagePostProcessor,
Ordered {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final boolean autoDecompress;
    private int order;

    public AbstractCompressingPostProcessor() {
        this(true);
    }

    public AbstractCompressingPostProcessor(boolean autoDecompress) {
        this.autoDecompress = autoDecompress;
    }

    @Override
    public Message postProcessMessage(Message message) throws AmqpException {
        ByteArrayOutputStream zipped = new ByteArrayOutputStream();
        try {
            OutputStream zipper = this.getCompressorStream(zipped);
            FileCopyUtils.copy((InputStream)new ByteArrayInputStream(message.getBody()), (OutputStream)zipper);
            MessageProperties messageProperties = message.getMessageProperties();
            String currentEncoding = messageProperties.getContentEncoding();
            messageProperties.setContentEncoding(this.getEncoding() + (currentEncoding == null ? "" : ":" + currentEncoding));
            if (this.autoDecompress) {
                messageProperties.setHeader("springAutoDecompress", true);
            }
            byte[] compressed = zipped.toByteArray();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Compressed " + message.getBody().length + " to " + compressed.length));
            }
            return new Message(compressed, messageProperties);
        }
        catch (IOException e) {
            throw new AmqpIOException(e);
        }
    }

    public int getOrder() {
        return this.order;
    }

    protected void setOrder(int order) {
        this.order = order;
    }

    protected abstract OutputStream getCompressorStream(OutputStream var1) throws IOException;

    protected abstract String getEncoding();
}

