/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.config;

import com.rabbitmq.stream.Environment;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.rabbit.config.BaseRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.ContainerCustomizer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.rabbit.stream.listener.ConsumerCustomizer;
import org.springframework.rabbit.stream.listener.StreamListenerContainer;
import org.springframework.rabbit.stream.listener.adapter.StreamMessageListenerAdapter;
import org.springframework.rabbit.stream.micrometer.RabbitStreamListenerObservationConvention;
import org.springframework.util.Assert;

public class StreamRabbitListenerContainerFactory
extends BaseRabbitListenerContainerFactory<StreamListenerContainer> {
    private final Environment environment;
    private boolean nativeListener;
    private ConsumerCustomizer consumerCustomizer;
    private ContainerCustomizer<StreamListenerContainer> containerCustomizer;
    private RabbitStreamListenerObservationConvention streamListenerObservationConvention;

    public StreamRabbitListenerContainerFactory(Environment environment) {
        Assert.notNull((Object)environment, (String)"'environment' cannot be null");
        this.environment = environment;
    }

    public void setNativeListener(boolean nativeListener) {
        this.nativeListener = nativeListener;
    }

    public void setConsumerCustomizer(ConsumerCustomizer consumerCustomizer) {
        this.consumerCustomizer = consumerCustomizer;
    }

    public void setContainerCustomizer(ContainerCustomizer<StreamListenerContainer> containerCustomizer) {
        this.containerCustomizer = containerCustomizer;
    }

    public void setStreamListenerObservationConvention(RabbitStreamListenerObservationConvention streamListenerObservationConvention) {
        this.streamListenerObservationConvention = streamListenerObservationConvention;
    }

    public StreamListenerContainer createListenerContainer(RabbitListenerEndpoint endpoint) {
        if (endpoint instanceof MethodRabbitListenerEndpoint) {
            MethodRabbitListenerEndpoint methodRabbitListenerEndpoint = (MethodRabbitListenerEndpoint)endpoint;
            if (this.nativeListener) {
                methodRabbitListenerEndpoint.setAdapterProvider((batch, bean, method, returnExceptions, errorHandler, batchingStrategy) -> {
                    Assert.isTrue((!batch ? 1 : 0) != 0, (String)"Batch listeners are not supported by the stream container");
                    return new StreamMessageListenerAdapter(bean, method, returnExceptions, errorHandler);
                });
            }
        }
        StreamListenerContainer container = this.createContainerInstance();
        Advice[] adviceChain = this.getAdviceChain();
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.getApplicationContext(), arg_0 -> ((StreamListenerContainer)container).setApplicationContext(arg_0)).acceptIfNotNull((Object)this.consumerCustomizer, container::setConsumerCustomizer).acceptIfNotNull((Object)adviceChain, container::setAdviceChain).acceptIfNotNull((Object)this.getMicrometerEnabled(), arg_0 -> ((StreamListenerContainer)container).setMicrometerEnabled(arg_0)).acceptIfNotNull((Object)this.getObservationEnabled(), arg_0 -> ((StreamListenerContainer)container).setObservationEnabled(arg_0)).acceptIfNotNull((Object)this.streamListenerObservationConvention, container::setObservationConvention);
        this.applyCommonOverrides(endpoint, (MessageListenerContainer)container);
        if (this.containerCustomizer != null) {
            this.containerCustomizer.configure((MessageListenerContainer)container);
        }
        return container;
    }

    protected StreamListenerContainer createContainerInstance() {
        return new StreamListenerContainer(this.environment);
    }
}

