/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ListenerContainerParser
implements BeanDefinitionParser {
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String TASK_EXECUTOR_ATTRIBUTE = "task-executor";
    private static final String ERROR_HANDLER_ATTRIBUTE = "error-handler";
    private static final String LISTENER_ELEMENT = "listener";
    private static final String ID_ATTRIBUTE = "id";
    private static final String QUEUE_NAMES_ATTRIBUTE = "queue-names";
    private static final String QUEUES_ATTRIBUTE = "queues";
    private static final String REF_ATTRIBUTE = "ref";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String MESSAGE_CONVERTER_ATTRIBUTE = "message-converter";
    private static final String RESPONSE_EXCHANGE_ATTRIBUTE = "response-exchange";
    private static final String RESPONSE_ROUTING_KEY_ATTRIBUTE = "response-routing-key";
    private static final String ACKNOWLEDGE_ATTRIBUTE = "acknowledge";
    private static final String ACKNOWLEDGE_AUTO = "auto";
    private static final String ACKNOWLEDGE_MANUAL = "manual";
    private static final String ACKNOWLEDGE_NONE = "none";
    private static final String TRANSACTION_MANAGER_ATTRIBUTE = "transaction-manager";
    private static final String CONCURRENCY_ATTRIBUTE = "concurrency";
    private static final String PREFETCH_ATTRIBUTE = "prefetch";
    private static final String TRANSACTION_SIZE_ATTRIBUTE = "transaction-size";
    private static final String PHASE_ATTRIBUTE = "phase";
    private static final String AUTO_STARTUP_ATTRIBUTE = "auto-startup";
    private static final String ADVICE_CHAIN_ATTRIBUTE = "advice-chain";

    ListenerContainerParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compositeDef);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String localName;
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1 || !LISTENER_ELEMENT.equals(localName = parserContext.getDelegate().getLocalName(child))) continue;
            this.parseListener((Element)child, element, parserContext);
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void parseListener(Element listenerEle, Element containerEle, ParserContext parserContext) {
        String queues;
        String queueNames;
        RootBeanDefinition listenerDef = new RootBeanDefinition();
        listenerDef.setSource(parserContext.extractSource((Object)listenerEle));
        String ref = listenerEle.getAttribute(REF_ATTRIBUTE);
        if (!StringUtils.hasText((String)ref)) {
            parserContext.getReaderContext().error("Listener 'ref' attribute contains empty value.", (Object)listenerEle);
        } else {
            listenerDef.getPropertyValues().add("delegate", (Object)new RuntimeBeanReference(ref));
        }
        String method = null;
        if (listenerEle.hasAttribute(METHOD_ATTRIBUTE) && !StringUtils.hasText((String)(method = listenerEle.getAttribute(METHOD_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("Listener 'method' attribute contains empty value.", (Object)listenerEle);
        }
        listenerDef.getPropertyValues().add("defaultListenerMethod", (Object)method);
        if (containerEle.hasAttribute(MESSAGE_CONVERTER_ATTRIBUTE)) {
            String messageConverter = containerEle.getAttribute(MESSAGE_CONVERTER_ATTRIBUTE);
            if (!StringUtils.hasText((String)messageConverter)) {
                parserContext.getReaderContext().error("Listener container 'message-converter' attribute contains empty value.", (Object)containerEle);
            } else {
                listenerDef.getPropertyValues().add("messageConverter", (Object)new RuntimeBeanReference(messageConverter));
            }
        }
        BeanDefinition containerDef = this.parseContainer(listenerEle, containerEle, parserContext);
        if (listenerEle.hasAttribute(RESPONSE_EXCHANGE_ATTRIBUTE)) {
            String responseExchange = listenerEle.getAttribute(RESPONSE_EXCHANGE_ATTRIBUTE);
            listenerDef.getPropertyValues().add("responseExchange", (Object)responseExchange);
        }
        if (listenerEle.hasAttribute(RESPONSE_ROUTING_KEY_ATTRIBUTE)) {
            String responseRoutingKey = listenerEle.getAttribute(RESPONSE_ROUTING_KEY_ATTRIBUTE);
            listenerDef.getPropertyValues().add("responseRoutingKey", (Object)responseRoutingKey);
        }
        listenerDef.setBeanClassName("org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter");
        containerDef.getPropertyValues().add("messageListener", (Object)listenerDef);
        String containerBeanName = containerEle.getAttribute(ID_ATTRIBUTE);
        if (!StringUtils.hasText((String)containerBeanName)) {
            containerBeanName = parserContext.getReaderContext().generateBeanName(containerDef);
        }
        if (!NamespaceUtils.isAttributeDefined(listenerEle, QUEUE_NAMES_ATTRIBUTE) && !NamespaceUtils.isAttributeDefined(listenerEle, QUEUES_ATTRIBUTE)) {
            parserContext.getReaderContext().error("Listener 'queue-names' or 'queues' attribute must be provided.", (Object)listenerEle);
        }
        if (NamespaceUtils.isAttributeDefined(listenerEle, QUEUE_NAMES_ATTRIBUTE) && NamespaceUtils.isAttributeDefined(listenerEle, QUEUES_ATTRIBUTE)) {
            parserContext.getReaderContext().error("Listener 'queue-names' or 'queues' attribute must be provided but not both.", (Object)listenerEle);
        }
        if (StringUtils.hasText((String)(queueNames = listenerEle.getAttribute(QUEUE_NAMES_ATTRIBUTE)))) {
            String[] names = StringUtils.commaDelimitedListToStringArray((String)queueNames);
            ManagedList values = new ManagedList();
            for (int i = 0; i < names.length; ++i) {
                values.add(new TypedStringValue(names[i].trim()));
            }
            containerDef.getPropertyValues().add("queueNames", (Object)values);
        }
        if (StringUtils.hasText((String)(queues = listenerEle.getAttribute(QUEUES_ATTRIBUTE)))) {
            String[] names = StringUtils.commaDelimitedListToStringArray((String)queues);
            ManagedList values = new ManagedList();
            for (int i = 0; i < names.length; ++i) {
                values.add(new RuntimeBeanReference(names[i].trim()));
            }
            containerDef.getPropertyValues().add(QUEUES_ATTRIBUTE, (Object)values);
        }
        parserContext.registerBeanComponent(new BeanComponentDefinition(containerDef, containerBeanName));
    }

    private BeanDefinition parseContainer(Element listenerEle, Element containerEle, ParserContext parserContext) {
        String adviceChain;
        String autoStartup;
        String phase;
        String transactionSize;
        String prefetch;
        String concurrency;
        String transactionManagerBeanName;
        AcknowledgeMode acknowledgeMode;
        String errorHandlerBeanName;
        String taskExecutorBeanName;
        RootBeanDefinition containerDef = new RootBeanDefinition(SimpleMessageListenerContainer.class);
        containerDef.setSource(parserContext.extractSource((Object)containerEle));
        String connectionFactoryBeanName = "rabbitConnectionFactory";
        if (containerEle.hasAttribute(CONNECTION_FACTORY_ATTRIBUTE) && !StringUtils.hasText((String)(connectionFactoryBeanName = containerEle.getAttribute(CONNECTION_FACTORY_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("Listener container 'connection-factory' attribute contains empty value.", (Object)containerEle);
        }
        if (StringUtils.hasText((String)connectionFactoryBeanName)) {
            containerDef.getPropertyValues().add("connectionFactory", (Object)new RuntimeBeanReference(connectionFactoryBeanName));
        }
        if (StringUtils.hasText((String)(taskExecutorBeanName = containerEle.getAttribute(TASK_EXECUTOR_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("taskExecutor", (Object)new RuntimeBeanReference(taskExecutorBeanName));
        }
        if (StringUtils.hasText((String)(errorHandlerBeanName = containerEle.getAttribute(ERROR_HANDLER_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("errorHandler", (Object)new RuntimeBeanReference(errorHandlerBeanName));
        }
        if ((acknowledgeMode = this.parseAcknowledgeMode(containerEle, parserContext)) != null) {
            containerDef.getPropertyValues().add("acknowledgeMode", (Object)acknowledgeMode);
        }
        if (StringUtils.hasText((String)(transactionManagerBeanName = containerEle.getAttribute(TRANSACTION_MANAGER_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("transactionManager", (Object)new RuntimeBeanReference(transactionManagerBeanName));
        }
        if (StringUtils.hasText((String)(concurrency = containerEle.getAttribute(CONCURRENCY_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("concurrentConsumers", (Object)new TypedStringValue(concurrency));
        }
        if (StringUtils.hasText((String)(prefetch = containerEle.getAttribute(PREFETCH_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("prefetchCount", (Object)new TypedStringValue(prefetch));
        }
        if (StringUtils.hasText((String)(transactionSize = containerEle.getAttribute(TRANSACTION_SIZE_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("txSize", (Object)new TypedStringValue(transactionSize));
        }
        if (StringUtils.hasText((String)(phase = containerEle.getAttribute(PHASE_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add(PHASE_ATTRIBUTE, (Object)phase);
        }
        if (StringUtils.hasText((String)(autoStartup = containerEle.getAttribute(AUTO_STARTUP_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("autoStartup", (Object)new TypedStringValue(autoStartup));
        }
        if (StringUtils.hasText((String)(adviceChain = containerEle.getAttribute(ADVICE_CHAIN_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("adviceChain", (Object)new RuntimeBeanReference(adviceChain));
        }
        return containerDef;
    }

    private AcknowledgeMode parseAcknowledgeMode(Element ele, ParserContext parserContext) {
        AcknowledgeMode acknowledgeMode = null;
        String acknowledge = ele.getAttribute(ACKNOWLEDGE_ATTRIBUTE);
        if (StringUtils.hasText((String)acknowledge)) {
            if (ACKNOWLEDGE_AUTO.equals(acknowledge)) {
                acknowledgeMode = AcknowledgeMode.AUTO;
            } else if (ACKNOWLEDGE_MANUAL.equals(acknowledge)) {
                acknowledgeMode = AcknowledgeMode.MANUAL;
            } else if (ACKNOWLEDGE_NONE.equals(acknowledge)) {
                acknowledgeMode = AcknowledgeMode.NONE;
            } else {
                parserContext.getReaderContext().error("Invalid listener container 'acknowledge' setting [" + acknowledge + "]: only \"auto\", \"manual\", and \"none\" supported.", (Object)ele);
            }
            return acknowledgeMode;
        }
        return null;
    }
}

