/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RabbitTemplate
extends RabbitAccessor
implements RabbitOperations {
    private static final String DEFAULT_EXCHANGE = "";
    private static final String DEFAULT_ROUTING_KEY = "";
    private static final long DEFAULT_REPLY_TIMEOUT = 5000L;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private volatile String exchange = "";
    private volatile String routingKey = "";
    private volatile String queue;
    private volatile long replyTimeout = 5000L;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private String encoding = "UTF-8";

    public RabbitTemplate() {
        this.initDefaultStrategies();
    }

    public RabbitTemplate(ConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter((MessageConverter)new SimpleMessageConverter());
    }

    public void setExchange(String exchange) {
        this.exchange = exchange != null ? exchange : "";
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        Assert.notNull((Object)messagePropertiesConverter, (String)"messagePropertiesConverter must not be null");
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void send(Message message) throws AmqpException {
        this.send(this.exchange, this.routingKey, message);
    }

    public void send(String routingKey, Message message) throws AmqpException {
        this.send(this.exchange, routingKey, message);
    }

    public void send(final String exchange, final String routingKey, final Message message) throws AmqpException {
        this.execute(new ChannelCallback<Object>(){

            @Override
            public Object doInRabbit(Channel channel) throws Exception {
                RabbitTemplate.this.doSend(channel, exchange, routingKey, message);
                return null;
            }
        });
    }

    public void convertAndSend(Object object) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, object);
    }

    public void convertAndSend(String routingKey, Object object) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, object);
    }

    public void convertAndSend(String exchange, String routingKey, Object object) throws AmqpException {
        this.send(exchange, routingKey, this.getRequiredMessageConverter().toMessage(object, new MessageProperties()));
    }

    public void convertAndSend(Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, message, messagePostProcessor);
    }

    public void convertAndSend(String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, message, messagePostProcessor);
    }

    public void convertAndSend(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        Message messageToSend = this.getRequiredMessageConverter().toMessage(message, new MessageProperties());
        messageToSend = messagePostProcessor.postProcessMessage(messageToSend);
        this.send(exchange, routingKey, messageToSend);
    }

    public Message receive() throws AmqpException {
        String queue = this.getRequiredQueue();
        return this.receive(queue);
    }

    public Message receive(final String queueName) {
        return this.execute(new ChannelCallback<Message>(){

            @Override
            public Message doInRabbit(Channel channel) throws IOException {
                GetResponse response = channel.basicGet(queueName, !RabbitTemplate.this.isChannelTransacted());
                if (response != null) {
                    long deliveryTag = response.getEnvelope().getDeliveryTag();
                    if (RabbitTemplate.this.isChannelLocallyTransacted(channel)) {
                        channel.basicAck(deliveryTag, false);
                        channel.txCommit();
                    } else if (RabbitTemplate.this.isChannelTransacted()) {
                        ConnectionFactoryUtils.registerDeliveryTag(RabbitTemplate.this.getConnectionFactory(), channel, deliveryTag);
                    }
                    MessageProperties messageProps = RabbitTemplate.this.messagePropertiesConverter.toMessageProperties(response.getProps(), response.getEnvelope(), RabbitTemplate.this.encoding);
                    messageProps.setMessageCount(Integer.valueOf(response.getMessageCount()));
                    return new Message(response.getBody(), messageProps);
                }
                return null;
            }
        });
    }

    public Object receiveAndConvert() throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue());
    }

    public Object receiveAndConvert(String queueName) throws AmqpException {
        Message response = this.receive(queueName);
        if (response != null) {
            return this.getRequiredMessageConverter().fromMessage(response);
        }
        return null;
    }

    public Message sendAndReceive(Message message) throws AmqpException {
        return this.doSendAndReceive(this.exchange, this.routingKey, message);
    }

    public Message sendAndReceive(String routingKey, Message message) throws AmqpException {
        return this.doSendAndReceive(this.exchange, routingKey, message);
    }

    public Message sendAndReceive(String exchange, String routingKey, Message message) throws AmqpException {
        return this.doSendAndReceive(exchange, routingKey, message);
    }

    public Object convertSendAndReceive(Object message) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, this.routingKey, message, null);
    }

    public Object convertSendAndReceive(String routingKey, Object message) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, routingKey, message, null);
    }

    public Object convertSendAndReceive(String exchange, String routingKey, Object message) throws AmqpException {
        return this.convertSendAndReceive(exchange, routingKey, message, null);
    }

    public Object convertSendAndReceive(Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, this.routingKey, message, messagePostProcessor);
    }

    public Object convertSendAndReceive(String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, routingKey, message, messagePostProcessor);
    }

    public Object convertSendAndReceive(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        Message replyMessage;
        MessageProperties messageProperties = new MessageProperties();
        Message requestMessage = this.getRequiredMessageConverter().toMessage(message, messageProperties);
        if (messagePostProcessor != null) {
            requestMessage = messagePostProcessor.postProcessMessage(requestMessage);
        }
        if ((replyMessage = this.doSendAndReceive(exchange, routingKey, requestMessage)) == null) {
            return null;
        }
        return this.getRequiredMessageConverter().fromMessage(replyMessage);
    }

    protected Message doSendAndReceive(final String exchange, final String routingKey, final Message message) {
        Message replyMessage = this.execute(new ChannelCallback<Message>(){

            @Override
            public Message doInRabbit(Channel channel) throws Exception {
                final SynchronousQueue replyHandoff = new SynchronousQueue();
                Assert.isNull((Object)message.getMessageProperties().getReplyTo(), (String)"Send-and-receive methods can only be used if the Message does not already have a replyTo property.");
                AMQP.Queue.DeclareOk queueDeclaration = channel.queueDeclare();
                String replyTo = queueDeclaration.getQueue();
                message.getMessageProperties().setReplyTo(replyTo);
                boolean noAck = false;
                String consumerTag = UUID.randomUUID().toString();
                boolean noLocal = true;
                boolean exclusive = true;
                DefaultConsumer consumer = new DefaultConsumer(channel){

                    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                        MessageProperties messageProperties = RabbitTemplate.this.messagePropertiesConverter.toMessageProperties(properties, envelope, RabbitTemplate.this.encoding);
                        Message reply = new Message(body, messageProperties);
                        try {
                            replyHandoff.put(reply);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                };
                channel.basicConsume(replyTo, noAck, consumerTag, noLocal, exclusive, null, (Consumer)consumer);
                RabbitTemplate.this.doSend(channel, exchange, routingKey, message);
                Message reply = RabbitTemplate.this.replyTimeout < 0L ? (Message)replyHandoff.take() : (Message)replyHandoff.poll(RabbitTemplate.this.replyTimeout, TimeUnit.MILLISECONDS);
                channel.basicCancel(consumerTag);
                return reply;
            }
        });
        return replyMessage;
    }

    @Override
    public <T> T execute(ChannelCallback<T> action) {
        Assert.notNull(action, (String)"Callback object must not be null");
        RabbitResourceHolder resourceHolder = this.getTransactionalResourceHolder();
        Channel channel = resourceHolder.getChannel();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing callback on RabbitMQ Channel: " + channel));
            }
            T t = action.doInRabbit(channel);
            return t;
        }
        catch (Exception ex) {
            if (this.isChannelLocallyTransacted(channel)) {
                resourceHolder.rollbackAll();
            }
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            ConnectionFactoryUtils.releaseResources(resourceHolder);
        }
    }

    protected void doSend(Channel channel, String exchange, String routingKey, Message message) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publishing message on exchange [" + exchange + "], routingKey = [" + routingKey + "]"));
        }
        if (exchange == null) {
            exchange = this.exchange;
        }
        if (routingKey == null) {
            routingKey = this.routingKey;
        }
        channel.basicPublish(exchange, routingKey, false, false, this.messagePropertiesConverter.fromMessageProperties(message.getMessageProperties(), this.encoding), message.getBody());
        if (this.isChannelLocallyTransacted(channel)) {
            RabbitUtils.commitIfNecessary(channel);
        }
    }

    protected boolean isChannelLocallyTransacted(Channel channel) {
        return this.isChannelTransacted() && !ConnectionFactoryUtils.isChannelTransactional(channel, this.getConnectionFactory());
    }

    private MessageConverter getRequiredMessageConverter() throws IllegalStateException {
        MessageConverter converter = this.getMessageConverter();
        if (converter == null) {
            throw new AmqpIllegalStateException("No 'messageConverter' specified. Check configuration of RabbitTemplate.");
        }
        return converter;
    }

    private String getRequiredQueue() throws IllegalStateException {
        String name = this.queue;
        if (name == null) {
            throw new AmqpIllegalStateException("No 'queue' specified. Check configuration of RabbitTemplate.");
        }
        return name;
    }
}

