/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.log4j;

import java.util.Calendar;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.MDC;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class AmqpAppender
extends AppenderSkeleton {
    public static final String APPLICATION_ID = "applicationId";
    public static final String CATEGORY_NAME = "categoryName";
    public static final String CATEGORY_LEVEL = "level";
    private String exchangeName = "logs";
    private String exchangeType = "topic";
    private String routingKeyPattern = "%c.%p";
    private Layout routingKeyLayout = new PatternLayout(this.routingKeyPattern);
    private final Object layoutMutex = new Object();
    private AtomicBoolean exchangeDeclared = new AtomicBoolean(false);
    private String applicationId = null;
    private LinkedBlockingQueue<Event> events = new LinkedBlockingQueue();
    private ExecutorService senderPool = null;
    private int senderPoolSize = 2;
    private int maxSenderRetries = 30;
    private Timer retryTimer = new Timer("log-event-retry-delay", true);
    private AbstractConnectionFactory connectionFactory;
    private String host = "localhost";
    private String virtualHost = "/";
    private int port = 5672;
    private String username = "guest";
    private String password = "guest";
    private String contentType = "text/plain";
    private String contentEncoding = null;
    private boolean declareExchange = false;
    private final String mutex = "mutex";
    private boolean durable = true;
    private boolean autoDelete = false;
    private boolean generateId = false;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getRoutingKeyPattern() {
        return this.routingKeyPattern;
    }

    public void setRoutingKeyPattern(String routingKeyPattern) {
        this.routingKeyPattern = routingKeyPattern;
        this.routingKeyLayout = new PatternLayout(routingKeyPattern);
    }

    public boolean isDeclareExchange() {
        return this.declareExchange;
    }

    public void setDeclareExchange(boolean declareExchange) {
        this.declareExchange = declareExchange;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public int getSenderPoolSize() {
        return this.senderPoolSize;
    }

    public void setSenderPoolSize(int senderPoolSize) {
        this.senderPoolSize = senderPoolSize;
    }

    public int getMaxSenderRetries() {
        return this.maxSenderRetries;
    }

    public void setMaxSenderRetries(int maxSenderRetries) {
        this.maxSenderRetries = maxSenderRetries;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean isGenerateId() {
        return this.generateId;
    }

    public void setGenerateId(boolean generateId) {
        this.generateId = generateId;
    }

    protected void startSenders() {
        this.senderPool = Executors.newCachedThreadPool();
        for (int i = 0; i < this.senderPoolSize; ++i) {
            this.senderPool.submit(new EventSender());
        }
    }

    protected void maybeDeclareExchange() {
        RabbitAdmin admin = new RabbitAdmin(this.connectionFactory);
        if (this.declareExchange) {
            Object x = "topic".equals(this.exchangeType) ? new TopicExchange(this.exchangeName, this.durable, this.autoDelete) : ("direct".equals(this.exchangeType) ? new DirectExchange(this.exchangeName, this.durable, this.autoDelete) : ("fanout".equals(this.exchangeType) ? new FanoutExchange(this.exchangeName, this.durable, this.autoDelete) : ("headers".equals(this.exchangeType) ? new HeadersExchange(this.exchangeType, this.durable, this.autoDelete) : new TopicExchange(this.exchangeName, this.durable, this.autoDelete))));
            admin.declareExchange((Exchange)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void append(LoggingEvent event) {
        if (null == this.senderPool) {
            String string = "mutex";
            // MONITORENTER : "mutex"
            this.connectionFactory = new CachingConnectionFactory();
            this.connectionFactory.setHost(this.host);
            this.connectionFactory.setPort(this.port);
            this.connectionFactory.setUsername(this.username);
            this.connectionFactory.setPassword(this.password);
            this.connectionFactory.setVirtualHost(this.virtualHost);
            this.maybeDeclareExchange();
            this.exchangeDeclared.set(true);
            this.startSenders();
            // MONITOREXIT : string
        }
        this.events.add(new Event(event, event.getProperties()));
    }

    public void close() {
        if (null != this.senderPool) {
            this.senderPool.shutdownNow();
            this.senderPool = null;
        }
        if (null != this.connectionFactory) {
            this.connectionFactory.destroy();
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    static /* synthetic */ AbstractConnectionFactory access$000(AmqpAppender x0) {
        return x0.connectionFactory;
    }

    static /* synthetic */ String access$200(AmqpAppender x0) {
        return x0.contentType;
    }

    static /* synthetic */ String access$300(AmqpAppender x0) {
        return x0.contentEncoding;
    }

    static /* synthetic */ boolean access$400(AmqpAppender x0) {
        return x0.generateId;
    }

    static /* synthetic */ String access$500(AmqpAppender x0) {
        return x0.applicationId;
    }

    static /* synthetic */ Object access$600(AmqpAppender x0) {
        return x0.layoutMutex;
    }

    static /* synthetic */ Layout access$700(AmqpAppender x0) {
        return x0.layout;
    }

    static /* synthetic */ Layout access$800(AmqpAppender x0) {
        return x0.routingKeyLayout;
    }

    static /* synthetic */ String access$900(AmqpAppender x0) {
        return x0.exchangeName;
    }

    static /* synthetic */ int access$1000(AmqpAppender x0) {
        return x0.maxSenderRetries;
    }

    static /* synthetic */ Timer access$1100(AmqpAppender x0) {
        return x0.retryTimer;
    }

    static /* synthetic */ ErrorHandler access$1200(AmqpAppender x0) {
        return x0.errorHandler;
    }

    protected class Event {
        final LoggingEvent event;
        final Map properties;
        AtomicInteger retries = new AtomicInteger(0);

        public Event(LoggingEvent event, Map properties) {
            this.event = event;
            this.properties = properties;
        }

        public LoggingEvent getEvent() {
            return this.event;
        }

        public Map getProperties() {
            return this.properties;
        }

        public int incrementRetries() {
            return this.retries.incrementAndGet();
        }
    }

    protected class EventSender
    implements Runnable {
        protected EventSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            try {
                rabbitTemplate = new RabbitTemplate(AmqpAppender.access$000(AmqpAppender.this));
                while (true) lbl-1000:
                // 5 sources

                {
                    event = (Event)AmqpAppender.access$100(AmqpAppender.this).take();
                    logEvent = event.getEvent();
                    name = logEvent.getLogger().getName();
                    level = logEvent.getLevel();
                    amqpProps = new MessageProperties();
                    amqpProps.setContentType(AmqpAppender.access$200(AmqpAppender.this));
                    if (null != AmqpAppender.access$300(AmqpAppender.this)) {
                        amqpProps.setContentEncoding(AmqpAppender.access$300(AmqpAppender.this));
                    }
                    amqpProps.setHeader("categoryName", (Object)name);
                    amqpProps.setHeader("level", (Object)level.toString());
                    if (AmqpAppender.access$400(AmqpAppender.this)) {
                        amqpProps.setMessageId(UUID.randomUUID().toString());
                    }
                    if (null != AmqpAppender.access$500(AmqpAppender.this)) {
                        amqpProps.setAppId(AmqpAppender.access$500(AmqpAppender.this));
                        MDC.put((String)"applicationId", (Object)AmqpAppender.access$500(AmqpAppender.this));
                    }
                    tstamp = Calendar.getInstance();
                    tstamp.setTimeInMillis(logEvent.getTimeStamp());
                    amqpProps.setTimestamp(tstamp.getTime());
                    props = event.getProperties();
                    for (Map.Entry<K, V> key : event.getProperties().entrySet()) {
                        amqpProps.setHeader(key.toString(), props.get(key));
                    }
                    locInfo = logEvent.getLocationInformation();
                    if (!"?".equals(locInfo.getClassName())) {
                        amqpProps.setHeader("location", (Object)String.format("%s.%s()[%s]", new Object[]{locInfo.getClassName(), locInfo.getMethodName(), locInfo.getLineNumber()}));
                    }
                    var12_13 = AmqpAppender.access$600(AmqpAppender.this);
                    synchronized (var12_13) {
                        msgBody = new StringBuilder(AmqpAppender.access$700(AmqpAppender.this).format(logEvent));
                        routingKey = AmqpAppender.access$800(AmqpAppender.this).format(logEvent);
                    }
                    if (null != logEvent.getThrowableInformation()) {
                        tinfo = logEvent.getThrowableInformation();
                        for (String line : tinfo.getThrowableStrRep()) {
                            msgBody.append(String.format("%s%n", new Object[]{line}));
                        }
                    }
                    try {
                        rabbitTemplate.send(AmqpAppender.access$900(AmqpAppender.this), routingKey, new Message(msgBody.toString().getBytes(), amqpProps));
                    }
                    catch (AmqpException e) {
                        retries = event.incrementRetries();
                        if (retries < AmqpAppender.access$1000(AmqpAppender.this)) {
                            AmqpAppender.access$1100(AmqpAppender.this).schedule(new TimerTask(){

                                public void run() {
                                    AmqpAppender.this.events.add(event);
                                }
                            }, (long)(Math.pow(retries, Math.log(retries)) * 1000.0));
                        }
                        AmqpAppender.access$1200(AmqpAppender.this).error("Could not send log message " + logEvent.getRenderedMessage() + " after " + AmqpAppender.access$1000(AmqpAppender.this) + " retries", (Exception)e, 1, logEvent);
                    }
                    finally {
                        if (null == AmqpAppender.access$500(AmqpAppender.this)) continue;
                        MDC.remove((String)"applicationId");
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getMessage(), t);
            }
            ** GOTO lbl-1000
        }
    }
}

