/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Map;
import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractExchangeParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ARGUMENTS_ELEMENT = "exchange-arguments";
    private static final String DURABLE_ATTRIBUTE = "durable";
    private static final String AUTO_DELETE_ATTRIBUTE = "auto-delete";
    private static String BINDINGS_ELE = "bindings";
    private static String BINDING_ELE = "binding";
    protected static final String BINDING_QUEUE_ATTR = "queue";
    protected static final String BINDING_EXCHANGE_ATTR = "exchange";

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String exchangeName = element.getAttribute("name");
        builder.addConstructorArgValue((Object)new TypedStringValue(exchangeName));
        this.parseBindings(element, parserContext, builder, exchangeName);
        NamespaceUtils.addConstructorArgBooleanValueIfAttributeDefined(builder, element, DURABLE_ATTRIBUTE, true);
        NamespaceUtils.addConstructorArgBooleanValueIfAttributeDefined(builder, element, AUTO_DELETE_ATTRIBUTE, false);
        Element argumentsElement = DomUtils.getChildElementByTagName((Element)element, (String)ARGUMENTS_ELEMENT);
        if (argumentsElement != null) {
            Map map = parserContext.getDelegate().parseMapElement(argumentsElement, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addConstructorArgValue((Object)map);
        }
        NamespaceUtils.parseDeclarationControls(element, builder);
    }

    protected void parseBindings(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String exchangeName) {
        Element bindingsElement = DomUtils.getChildElementByTagName((Element)element, (String)BINDINGS_ELE);
        this.doParseBindings(element, parserContext, exchangeName, bindingsElement, this);
    }

    protected void doParseBindings(Element element, ParserContext parserContext, String exchangeName, Element bindings, AbstractExchangeParser parser) {
        if (bindings != null) {
            for (Element binding : DomUtils.getChildElementsByTagName((Element)bindings, (String)BINDING_ELE)) {
                BeanDefinitionBuilder bindingBuilder = parser.parseBinding(exchangeName, binding, parserContext);
                NamespaceUtils.parseDeclarationControls(element, bindingBuilder);
                AbstractBeanDefinition beanDefinition = bindingBuilder.getBeanDefinition();
                this.registerBeanDefinition(new BeanDefinitionHolder((BeanDefinition)beanDefinition, parserContext.getReaderContext().generateBeanName((BeanDefinition)beanDefinition)), parserContext.getRegistry());
            }
        }
    }

    protected abstract BeanDefinitionBuilder parseBinding(String var1, Element var2, ParserContext var3);

    protected void parseDestination(Element binding, ParserContext parserContext, BeanDefinitionBuilder builder) {
        boolean hasExchangeAttribute;
        String queueAttribute = binding.getAttribute(BINDING_QUEUE_ATTR);
        String exchangeAttribute = binding.getAttribute(BINDING_EXCHANGE_ATTR);
        boolean hasQueueAttribute = StringUtils.hasText((String)queueAttribute);
        if (!(hasQueueAttribute ^ (hasExchangeAttribute = StringUtils.hasText((String)exchangeAttribute)))) {
            parserContext.getReaderContext().error("Binding must have exactly one of 'queue' or 'exchange'", (Object)binding);
        }
        if (hasQueueAttribute) {
            builder.addPropertyReference("destinationQueue", queueAttribute);
        }
        if (hasExchangeAttribute) {
            builder.addPropertyReference("destinationExchange", exchangeAttribute);
        }
    }
}

