/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.core.FederatedExchange;
import org.springframework.amqp.rabbit.config.AbstractExchangeParser;
import org.springframework.amqp.rabbit.config.DirectExchangeParser;
import org.springframework.amqp.rabbit.config.FanoutExchangeParser;
import org.springframework.amqp.rabbit.config.HeadersExchangeParser;
import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.amqp.rabbit.config.TopicExchangeParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FederatedExchangeParser
extends AbstractExchangeParser {
    private static final String BACKING_TYPE_ATTRIBUTE = "backing-type";
    private static final String UPSTREAM_SET_ATTRIBUTE = "upstream-set";
    private static final String DIRECT_BINDINGS_ELE = "direct-bindings";
    private static final String TOPIC_BINDINGS_ELE = "topic-bindings";
    private static final String TOPIC_FANOUT_ELE = "fanout-bindings";
    private static final String TOPIC_HEADERS_ELE = "headers-bindings";

    protected Class<?> getBeanClass(Element element) {
        return FederatedExchange.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, BACKING_TYPE_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, UPSTREAM_SET_ATTRIBUTE);
    }

    @Override
    protected void parseBindings(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String exchangeName) {
        String backingType = element.getAttribute(BACKING_TYPE_ATTRIBUTE);
        Element bindingsElement = DomUtils.getChildElementByTagName((Element)element, (String)DIRECT_BINDINGS_ELE);
        if (bindingsElement != null && !"direct".equals(backingType)) {
            parserContext.getReaderContext().error("Cannot have direct-bindings if backing-type not 'direct'", (Object)element);
        }
        if (bindingsElement == null && (bindingsElement = DomUtils.getChildElementByTagName((Element)element, (String)TOPIC_BINDINGS_ELE)) != null && !"topic".equals(backingType)) {
            parserContext.getReaderContext().error("Cannot have topic-bindings if backing-type not 'topic'", (Object)element);
        }
        if (bindingsElement == null && (bindingsElement = DomUtils.getChildElementByTagName((Element)element, (String)TOPIC_FANOUT_ELE)) != null && !"fanout".equals(backingType)) {
            parserContext.getReaderContext().error("Cannot have fanout-bindings if backing-type not 'fanout'", (Object)element);
        }
        if (bindingsElement == null && (bindingsElement = DomUtils.getChildElementByTagName((Element)element, (String)TOPIC_HEADERS_ELE)) != null && !"headers".equals(backingType)) {
            parserContext.getReaderContext().error("Cannot have headers-bindings if backing-type not 'headers'", (Object)element);
        }
        if (StringUtils.hasText((String)backingType)) {
            if ("direct".equals(backingType)) {
                this.doParseBindings(element, parserContext, exchangeName, bindingsElement, new DirectExchangeParser());
            } else if ("topic".equals(backingType)) {
                this.doParseBindings(element, parserContext, exchangeName, bindingsElement, new TopicExchangeParser());
            } else if ("fanout".equals(backingType)) {
                this.doParseBindings(element, parserContext, exchangeName, bindingsElement, new FanoutExchangeParser());
            } else if ("headers".equals(backingType)) {
                this.doParseBindings(element, parserContext, exchangeName, bindingsElement, new HeadersExchangeParser());
            }
        }
    }

    @Override
    protected BeanDefinitionBuilder parseBinding(String exchangeName, Element binding, ParserContext parserContext) {
        throw new UnsupportedOperationException("Not supported for federated exchange");
    }
}

