/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.rabbit.listener.FatalExceptionStrategy;
import org.springframework.amqp.rabbit.listener.ListenerExecutionFailedException;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.util.ErrorHandler;

public final class ConditionalRejectingErrorHandler
implements ErrorHandler {
    protected static final Log logger = LogFactory.getLog(ConditionalRejectingErrorHandler.class);
    private final FatalExceptionStrategy exceptionStrategy;

    public ConditionalRejectingErrorHandler() {
        this.exceptionStrategy = new DefaultExceptionStrategy();
    }

    public ConditionalRejectingErrorHandler(FatalExceptionStrategy exceptionStrategy) {
        this.exceptionStrategy = exceptionStrategy;
    }

    public void handleError(Throwable t) {
        if (!this.causeChainContainsARADRE(t) && this.exceptionStrategy.isFatal(t)) {
            throw new AmqpRejectAndDontRequeueException("Error Handler converted exception to fatal", t);
        }
    }

    private boolean causeChainContainsARADRE(Throwable t) {
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof AmqpRejectAndDontRequeueException)) continue;
            return true;
        }
        return false;
    }

    private class DefaultExceptionStrategy
    implements FatalExceptionStrategy {
        private DefaultExceptionStrategy() {
        }

        @Override
        public boolean isFatal(Throwable t) {
            if (t instanceof ListenerExecutionFailedException && t.getCause() instanceof MessageConversionException) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Fatal message conversion error; message rejected; it will be dropped or routed to a dead letter exchange, if so configured: " + ((ListenerExecutionFailedException)((Object)t)).getFailedMessage()), t);
                }
                return true;
            }
            return false;
        }
    }
}

