/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.List;
import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.amqp.rabbit.config.RabbitNamespaceUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class TemplateParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String EXCHANGE_ATTRIBUTE = "exchange";
    private static final String QUEUE_ATTRIBUTE = "queue";
    private static final String ROUTING_KEY_ATTRIBUTE = "routing-key";
    private static final String RECEIVE_TIMEOUT_ATTRIBUTE = "receive-timeout";
    private static final String REPLY_TIMEOUT_ATTRIBUTE = "reply-timeout";
    private static final String MESSAGE_CONVERTER_ATTRIBUTE = "message-converter";
    private static final String ENCODING_ATTRIBUTE = "encoding";
    private static final String CHANNEL_TRANSACTED_ATTRIBUTE = "channel-transacted";
    private static final String REPLY_QUEUE_ATTRIBUTE = "reply-queue";
    private static final String REPLY_ADDRESS_ATTRIBUTE = "reply-address";
    private static final String USE_TEMPORARY_REPLY_QUEUES_ATTRIBUTE = "use-temporary-reply-queues";
    private static final String LISTENER_ELEMENT = "reply-listener";
    private static final String MANDATORY_ATTRIBUTE = "mandatory";
    private static final String RETURN_CALLBACK_ATTRIBUTE = "return-callback";
    private static final String CONFIRM_CALLBACK_ATTRIBUTE = "confirm-callback";
    private static final String CORRELATION_KEY = "correlation-key";
    private static final String RETRY_TEMPLATE = "retry-template";
    private static final String RECOVERY_CALLBACK = "recovery-callback";

    TemplateParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return RabbitTemplate.class;
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return false;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinition receiveConnectionFactorySelectorExpression;
        BeanDefinition sendConnectionFactorySelectorExpression;
        String connectionFactoryRef = element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE);
        if (!StringUtils.hasText((String)connectionFactoryRef)) {
            parserContext.getReaderContext().error("A 'connection-factory' attribute must be set.", (Object)element);
        }
        if (StringUtils.hasText((String)connectionFactoryRef)) {
            builder.addConstructorArgReference(connectionFactoryRef);
        }
        NamespaceUtils.setValueIfAttributeDefined(builder, element, CHANNEL_TRANSACTED_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, QUEUE_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, EXCHANGE_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, ROUTING_KEY_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, RECEIVE_TIMEOUT_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, REPLY_TIMEOUT_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, ENCODING_ATTRIBUTE);
        NamespaceUtils.setReferenceIfAttributeDefined(builder, element, MESSAGE_CONVERTER_ATTRIBUTE);
        String replyAddress = element.getAttribute(REPLY_ADDRESS_ATTRIBUTE);
        if (!StringUtils.hasText((String)replyAddress)) {
            NamespaceUtils.setReferenceIfAttributeDefined(builder, element, REPLY_QUEUE_ATTRIBUTE, Conventions.attributeNameToPropertyName((String)REPLY_ADDRESS_ATTRIBUTE));
        }
        NamespaceUtils.setValueIfAttributeDefined(builder, element, USE_TEMPORARY_REPLY_QUEUES_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, REPLY_ADDRESS_ATTRIBUTE);
        NamespaceUtils.setReferenceIfAttributeDefined(builder, element, RETURN_CALLBACK_ATTRIBUTE);
        NamespaceUtils.setReferenceIfAttributeDefined(builder, element, CONFIRM_CALLBACK_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, CORRELATION_KEY);
        NamespaceUtils.setReferenceIfAttributeDefined(builder, element, RETRY_TEMPLATE);
        NamespaceUtils.setReferenceIfAttributeDefined(builder, element, RECOVERY_CALLBACK);
        BeanDefinition expressionDef = NamespaceUtils.createExpressionDefinitionFromValueOrExpression(MANDATORY_ATTRIBUTE, "mandatory-expression", parserContext, element, false);
        if (expressionDef != null) {
            builder.addPropertyValue("mandatoryExpression", (Object)expressionDef);
        }
        if ((sendConnectionFactorySelectorExpression = NamespaceUtils.createExpressionDefIfAttributeDefined("send-connection-factory-selector-expression", element)) != null) {
            builder.addPropertyValue("sendConnectionFactorySelectorExpression", (Object)sendConnectionFactorySelectorExpression);
        }
        if ((receiveConnectionFactorySelectorExpression = NamespaceUtils.createExpressionDefIfAttributeDefined("receive-connection-factory-selector-expression", element)) != null) {
            builder.addPropertyValue("receiveConnectionFactorySelectorExpression", (Object)receiveConnectionFactorySelectorExpression);
        }
        BeanDefinition replyContainer = null;
        Element childElement = null;
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)LISTENER_ELEMENT);
        if (childElements.size() > 0) {
            childElement = (Element)childElements.get(0);
        }
        if (childElement != null && (replyContainer = this.parseListener(childElement, element, parserContext)) != null) {
            replyContainer.getPropertyValues().add("messageListener", (Object)new RuntimeBeanReference(element.getAttribute("id")));
            String replyContainerName = element.getAttribute("id") + ".replyListener";
            parserContext.getRegistry().registerBeanDefinition(replyContainerName, replyContainer);
        }
        if (replyContainer == null && element.hasAttribute(REPLY_QUEUE_ATTRIBUTE)) {
            parserContext.getReaderContext().error("For template '" + element.getAttribute("id") + "', when specifying a reply-queue, " + "a <reply-listener/> element is required", (Object)element);
        } else if (replyContainer != null && !element.hasAttribute(REPLY_QUEUE_ATTRIBUTE)) {
            parserContext.getReaderContext().error("For template '" + element.getAttribute("id") + "', a <reply-listener/> element is not allowed if no " + "'reply-queue' is supplied", (Object)element);
        }
    }

    private BeanDefinition parseListener(Element childElement, Element element, ParserContext parserContext) {
        BeanDefinition replyContainer = RabbitNamespaceUtils.parseContainer(childElement, parserContext);
        if (replyContainer != null) {
            replyContainer.getPropertyValues().add("connectionFactory", (Object)new RuntimeBeanReference(element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE)));
        }
        if (element.hasAttribute(REPLY_QUEUE_ATTRIBUTE)) {
            replyContainer.getPropertyValues().add("queues", (Object)new RuntimeBeanReference(element.getAttribute(REPLY_QUEUE_ATTRIBUTE)));
        }
        return replyContainer;
    }
}

