/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.util.Arrays;
import java.util.List;
import org.springframework.amqp.event.AmqpEvent;

public class ListenerContainerIdleEvent
extends AmqpEvent {
    private final long idleTime;
    private final String listenerId;
    private final List<String> queueNames;

    public ListenerContainerIdleEvent(Object source, long idleTime, String id, String ... queueNames) {
        super(source);
        this.idleTime = idleTime;
        this.listenerId = id;
        this.queueNames = Arrays.asList(queueNames);
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public String[] getQueueNames() {
        return this.queueNames.toArray(new String[this.queueNames.size()]);
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String toString() {
        return "ListenerContainerIdleEvent [idleTime=" + (float)this.idleTime / 1000.0f + "s, listenerId=" + this.listenerId + ", container=" + this.getSource() + "]";
    }
}

