/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public abstract class AbstractRabbitListenerContainerFactory<C extends AbstractMessageListenerContainer>
implements RabbitListenerContainerFactory<C>,
ApplicationContextAware,
ApplicationEventPublisherAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final AtomicInteger counter = new AtomicInteger();
    private ConnectionFactory connectionFactory;
    private ErrorHandler errorHandler;
    private MessageConverter messageConverter;
    private AcknowledgeMode acknowledgeMode;
    private Boolean channelTransacted;
    private Executor taskExecutor;
    private PlatformTransactionManager transactionManager;
    private Integer prefetchCount;
    private Boolean defaultRequeueRejected;
    private Advice[] adviceChain;
    private BackOff recoveryBackOff;
    private Boolean missingQueuesFatal;
    private Boolean mismatchedQueuesFatal;
    private ConsumerTagStrategy consumerTagStrategy;
    private Long idleEventInterval;
    private Long failedDeclarationRetryInterval;
    private ApplicationEventPublisher applicationEventPublisher;
    private ApplicationContext applicationContext;
    private Boolean autoStartup;
    private Integer phase;
    private MessagePostProcessor[] afterReceivePostProcessors;
    private MessagePostProcessor[] beforeSendReplyPostProcessors;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<?> recoveryCallback;
    private Consumer<C> containerConfigurer;

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setChannelTransacted(Boolean channelTransacted) {
        this.channelTransacted = channelTransacted;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setPrefetchCount(Integer prefetch) {
        this.prefetchCount = prefetch;
    }

    public void setDefaultRequeueRejected(Boolean requeueRejected) {
        this.defaultRequeueRejected = requeueRejected;
    }

    public Advice[] getAdviceChain() {
        return Arrays.copyOf(this.adviceChain, this.adviceChain.length);
    }

    public void setAdviceChain(Advice ... adviceChain) {
        this.adviceChain = adviceChain == null ? null : Arrays.copyOf(adviceChain, adviceChain.length);
    }

    public void setRecoveryInterval(Long recoveryInterval) {
        this.recoveryBackOff = new FixedBackOff(recoveryInterval.longValue(), Long.MAX_VALUE);
    }

    public void setRecoveryBackOff(BackOff recoveryBackOff) {
        this.recoveryBackOff = recoveryBackOff;
    }

    public void setMissingQueuesFatal(Boolean missingQueuesFatal) {
        this.missingQueuesFatal = missingQueuesFatal;
    }

    public void setMismatchedQueuesFatal(Boolean mismatchedQueuesFatal) {
        this.mismatchedQueuesFatal = mismatchedQueuesFatal;
    }

    public void setConsumerTagStrategy(ConsumerTagStrategy consumerTagStrategy) {
        this.consumerTagStrategy = consumerTagStrategy;
    }

    public void setIdleEventInterval(Long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setFailedDeclarationRetryInterval(Long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        this.afterReceivePostProcessors = afterReceivePostProcessors;
    }

    public void setBeforeSendReplyPostProcessors(MessagePostProcessor ... beforeSendReplyPostProcessors) {
        this.beforeSendReplyPostProcessors = beforeSendReplyPostProcessors;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setReplyRecoveryCallback(RecoveryCallback<?> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setContainerConfigurer(Consumer<C> configurer) {
        this.containerConfigurer = configurer;
    }

    @Override
    public C createListenerContainer(RabbitListenerEndpoint endpoint) {
        C instance = this.createContainerInstance();
        if (this.connectionFactory != null) {
            ((RabbitAccessor)instance).setConnectionFactory(this.connectionFactory);
        }
        if (this.errorHandler != null) {
            ((AbstractMessageListenerContainer)instance).setErrorHandler(this.errorHandler);
        }
        if (this.messageConverter != null) {
            if (endpoint != null) {
                endpoint.setMessageConverter(this.messageConverter);
                if (endpoint.getMessageConverter() == null) {
                    ((AbstractMessageListenerContainer)instance).setMessageConverter(this.messageConverter);
                }
            } else {
                ((AbstractMessageListenerContainer)instance).setMessageConverter(this.messageConverter);
            }
        }
        if (this.acknowledgeMode != null) {
            ((AbstractMessageListenerContainer)instance).setAcknowledgeMode(this.acknowledgeMode);
        }
        if (this.channelTransacted != null) {
            ((RabbitAccessor)instance).setChannelTransacted(this.channelTransacted);
        }
        if (this.applicationContext != null) {
            ((AbstractMessageListenerContainer)instance).setApplicationContext(this.applicationContext);
        }
        if (this.taskExecutor != null) {
            ((AbstractMessageListenerContainer)instance).setTaskExecutor(this.taskExecutor);
        }
        if (this.transactionManager != null) {
            ((AbstractMessageListenerContainer)instance).setTransactionManager(this.transactionManager);
        }
        if (this.prefetchCount != null) {
            ((AbstractMessageListenerContainer)instance).setPrefetchCount(this.prefetchCount);
        }
        if (this.defaultRequeueRejected != null) {
            ((AbstractMessageListenerContainer)instance).setDefaultRequeueRejected(this.defaultRequeueRejected);
        }
        if (this.adviceChain != null) {
            ((AbstractMessageListenerContainer)instance).setAdviceChain(this.adviceChain);
        }
        if (this.recoveryBackOff != null) {
            ((AbstractMessageListenerContainer)instance).setRecoveryBackOff(this.recoveryBackOff);
        }
        if (this.mismatchedQueuesFatal != null) {
            ((AbstractMessageListenerContainer)instance).setMismatchedQueuesFatal(this.mismatchedQueuesFatal);
        }
        if (this.missingQueuesFatal != null) {
            ((AbstractMessageListenerContainer)instance).setMissingQueuesFatal(this.missingQueuesFatal);
        }
        if (this.consumerTagStrategy != null) {
            ((AbstractMessageListenerContainer)instance).setConsumerTagStrategy(this.consumerTagStrategy);
        }
        if (this.idleEventInterval != null) {
            ((AbstractMessageListenerContainer)instance).setIdleEventInterval(this.idleEventInterval);
        }
        if (this.failedDeclarationRetryInterval != null) {
            ((AbstractMessageListenerContainer)instance).setFailedDeclarationRetryInterval(this.failedDeclarationRetryInterval);
        }
        if (this.applicationEventPublisher != null) {
            ((AbstractMessageListenerContainer)instance).setApplicationEventPublisher(this.applicationEventPublisher);
        }
        if (this.autoStartup != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(this.autoStartup);
        }
        if (this.phase != null) {
            ((AbstractMessageListenerContainer)instance).setPhase(this.phase);
        }
        if (this.afterReceivePostProcessors != null) {
            ((AbstractMessageListenerContainer)instance).setAfterReceivePostProcessors(this.afterReceivePostProcessors);
        }
        if (endpoint != null) {
            if (endpoint.getAutoStartup() != null) {
                ((AbstractMessageListenerContainer)instance).setAutoStartup(endpoint.getAutoStartup());
            }
            ((AbstractMessageListenerContainer)instance).setListenerId(endpoint.getId());
            endpoint.setupListenerContainer((MessageListenerContainer)instance);
        }
        if (((AbstractMessageListenerContainer)instance).getMessageListener() instanceof AbstractAdaptableMessageListener) {
            AbstractAdaptableMessageListener messageListener = (AbstractAdaptableMessageListener)((AbstractMessageListenerContainer)instance).getMessageListener();
            if (this.beforeSendReplyPostProcessors != null) {
                messageListener.setBeforeSendReplyPostProcessors(this.beforeSendReplyPostProcessors);
            }
            if (this.retryTemplate != null) {
                messageListener.setRetryTemplate(this.retryTemplate);
                if (this.recoveryCallback != null) {
                    messageListener.setRecoveryCallback(this.recoveryCallback);
                }
            }
        }
        this.initializeContainer(instance, endpoint);
        if (this.containerConfigurer != null) {
            this.containerConfigurer.accept(instance);
        }
        return instance;
    }

    protected abstract C createContainerInstance();

    protected void initializeContainer(C instance, RabbitListenerEndpoint endpoint) {
    }
}

