/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.listener.adapter.InvocationResult;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class DelegatingInvocableHandler {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final ParserContext PARSER_CONTEXT = new TemplateParserContext("!{", "}");
    private final List<InvocableHandlerMethod> handlers;
    private final ConcurrentMap<Class<?>, InvocableHandlerMethod> cachedHandlers = new ConcurrentHashMap();
    private final InvocableHandlerMethod defaultHandler;
    private final Map<InvocableHandlerMethod, Expression> handlerSendTo = new ConcurrentHashMap<InvocableHandlerMethod, Expression>();
    private final Object bean;
    private final BeanExpressionResolver resolver;
    private final BeanExpressionContext beanExpressionContext;

    public DelegatingInvocableHandler(List<InvocableHandlerMethod> handlers, Object bean, BeanExpressionResolver beanExpressionResolver, BeanExpressionContext beanExpressionContext) {
        this(handlers, null, bean, beanExpressionResolver, beanExpressionContext);
    }

    public DelegatingInvocableHandler(List<InvocableHandlerMethod> handlers, @Nullable InvocableHandlerMethod defaultHandler, Object bean, BeanExpressionResolver beanExpressionResolver, BeanExpressionContext beanExpressionContext) {
        this.handlers = new ArrayList<InvocableHandlerMethod>(handlers);
        this.defaultHandler = defaultHandler;
        this.bean = bean;
        this.resolver = beanExpressionResolver;
        this.beanExpressionContext = beanExpressionContext;
    }

    public Object getBean() {
        return this.bean;
    }

    public InvocationResult invoke(Message<?> message, Object ... providedArgs) throws Exception {
        Expression replyTo;
        Class<?> payloadClass = message.getPayload().getClass();
        InvocableHandlerMethod handler = this.getHandlerForPayload(payloadClass);
        Object result = handler.invoke(message, providedArgs);
        if (message.getHeaders().get((Object)"amqp_replyTo") == null && (replyTo = this.handlerSendTo.get(handler)) != null) {
            return new InvocationResult(result, replyTo, handler.getMethod().getGenericReturnType(), handler.getBean(), handler.getMethod());
        }
        return new InvocationResult(result, null, handler.getMethod().getGenericReturnType(), handler.getBean(), handler.getMethod());
    }

    protected InvocableHandlerMethod getHandlerForPayload(Class<? extends Object> payloadClass) {
        InvocableHandlerMethod handler = (InvocableHandlerMethod)this.cachedHandlers.get(payloadClass);
        if (handler == null) {
            handler = this.findHandlerForPayload(payloadClass);
            if (handler == null) {
                throw new AmqpException("No method found for " + payloadClass);
            }
            this.cachedHandlers.putIfAbsent(payloadClass, handler);
            this.setupReplyTo(handler);
        }
        return handler;
    }

    private void setupReplyTo(InvocableHandlerMethod handler) {
        String replyTo = null;
        Method method = handler.getMethod();
        if (method != null) {
            SendTo ann = (SendTo)AnnotationUtils.getAnnotation((Method)method, SendTo.class);
            replyTo = this.extractSendTo(method.toString(), ann);
        }
        if (replyTo == null) {
            Class beanType = handler.getBeanType();
            SendTo ann = (SendTo)AnnotationUtils.getAnnotation((AnnotatedElement)beanType, SendTo.class);
            replyTo = this.extractSendTo(beanType.getSimpleName(), ann);
        }
        if (replyTo != null) {
            this.handlerSendTo.put(handler, PARSER.parseExpression(replyTo, PARSER_CONTEXT));
        }
    }

    private String extractSendTo(String element, SendTo ann) {
        String replyTo = null;
        if (ann != null) {
            Object[] destinations = ann.value();
            if (destinations.length > 1) {
                throw new IllegalStateException("Invalid @" + SendTo.class.getSimpleName() + " annotation on '" + element + "' one destination must be set (got " + Arrays.toString(destinations) + ")");
            }
            replyTo = destinations.length == 1 ? this.resolve(destinations[0]) : null;
        }
        return replyTo;
    }

    private String resolve(String value) {
        if (this.resolver != null) {
            String resolvedValue = this.beanExpressionContext.getBeanFactory().resolveEmbeddedValue(value);
            Object newValue = this.resolver.evaluate(resolvedValue, this.beanExpressionContext);
            Assert.isInstanceOf(String.class, (Object)newValue, (String)"Invalid @SendTo expression");
            return (String)newValue;
        }
        return value;
    }

    protected InvocableHandlerMethod findHandlerForPayload(Class<? extends Object> payloadClass) {
        InvocableHandlerMethod result = null;
        for (InvocableHandlerMethod handler : this.handlers) {
            if (!this.matchHandlerMethod(payloadClass, handler)) continue;
            if (result != null) {
                boolean resultIsDefault = result.equals((Object)this.defaultHandler);
                if (!handler.equals((Object)this.defaultHandler) && !resultIsDefault) {
                    throw new AmqpException("Ambiguous methods for payload type: " + payloadClass + ": " + result.getMethod().getName() + " and " + handler.getMethod().getName());
                }
                if (!resultIsDefault) continue;
            }
            result = handler;
        }
        return result != null ? result : this.defaultHandler;
    }

    protected boolean matchHandlerMethod(Class<? extends Object> payloadClass, InvocableHandlerMethod handler) {
        MethodParameter methodParameter;
        Method method = handler.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length == 1 && ((methodParameter = new MethodParameter(method, 0)).getParameterAnnotations().length == 0 || !methodParameter.hasParameterAnnotation(Header.class)) && methodParameter.getParameterType().isAssignableFrom(payloadClass)) {
            return true;
        }
        boolean foundCandidate = false;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            MethodParameter methodParameter2 = new MethodParameter(method, i);
            if (methodParameter2.getParameterAnnotations().length != 0 && methodParameter2.hasParameterAnnotation(Header.class) || !methodParameter2.getParameterType().isAssignableFrom(payloadClass)) continue;
            if (foundCandidate) {
                throw new AmqpException("Ambiguous payload parameter for " + method.toGenericString());
            }
            foundCandidate = true;
        }
        return foundCandidate;
    }

    public String getMethodNameFor(Object payload) {
        InvocableHandlerMethod handlerForPayload = null;
        try {
            handlerForPayload = this.getHandlerForPayload(payload.getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handlerForPayload == null ? "no match" : handlerForPayload.getMethod().toGenericString();
    }

    public Method getMethodFor(Object payload) {
        return this.getHandlerForPayload(payload.getClass()).getMethod();
    }

    public boolean hasDefaultHandler() {
        return this.defaultHandler != null;
    }

    @Nullable
    public InvocationResult getInvocationResultFor(Object result, Object inboundPayload) {
        InvocableHandlerMethod handler = this.findHandlerForPayload(inboundPayload.getClass());
        if (handler != null) {
            return new InvocationResult(result, this.handlerSendTo.get(handler), handler.getMethod().getGenericReturnType(), handler.getBean(), handler.getMethod());
        }
        return null;
    }
}

